<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<xsl:output method="html" media-type="text/html"></xsl:output>

	<xsl:param name="REDUCED_VIEW_PROCESSING" select="'false'"/>
	<xsl:param name="FILTERED_CODE_VALUES" select="''"/>
	<xsl:param name="LANGUAGE" select="'en'"/>
	<xsl:param name="ORBIS_REPORT" select="'false'"/>
	

	<!-- *****************************************
		THE STYLESHEET PROCESSING ENTRY-POINT
	********************************************* -->
	<xsl:template match="/">
		<xsl:apply-templates select="NativeDicomModel"/>
	</xsl:template>
		
	
	<xsl:template match="NativeDicomModel">
		<html>
			<head>
				<title>
					<xsl:value-of select="DicomAttribute[@tag='0040A043']/Item/DicomAttribute[@tag='00080104']/Value[@number='1']"/>
				</title>
			</head>
			<body>
				<!-- report title: coded as the code meaning of root level ConceptNameCodeSequence -->
				<b><font size="+2"><xsl:value-of select="DicomAttribute[@tag='0040A043']/Item/DicomAttribute[@tag='00080104']/Value[@number='1']"/></font></b><br/>
				
				<!-- encoded code value and designator for the report title code sequence -->
				<font size="-2"><xsl:value-of select="DicomAttribute[@tag='0040A043']/Item/DicomAttribute[@tag='00080100']/Value[@number='1']"/></font>
				,
				<font size="-2"><xsl:value-of select="DicomAttribute[@tag='0040A043']/Item/DicomAttribute[@tag='00080102']/Value[@number='1']"/></font><br/>
				<br/>
				
				<hr/>
				
				<table border="0" width="100%">					
					<tr>
						<td align="left" valign="top">
							<table align="left" border="0">
								<tr>
									<td>REPORT_STATUS</td>
									<td><b>
										<xsl:value-of select="DicomAttribute[@tag='0040A491']/Value[@number='1']"/>, 
										<xsl:value-of select="DicomAttribute[@tag='0040A493']/Value[@number='1']"/>
										</b>
									</td>
								</tr>
								<xsl:choose>
									<xsl:when test="$ORBIS_REPORT='false'">
										<tr>
											<td>REPORT_DATE</td>
											<td><b><DATETIME>
											<xsl:value-of select="DicomAttribute[@tag='00080023']/Value[@number='1']"/> <xsl:value-of select="DicomAttribute[@tag='00080033']/Value[@number='1']"/>
											</DATETIME></b></td>
										</tr>
									</xsl:when>
									<xsl:otherwise>
										ORBIS_REPORT_HISTORY
									</xsl:otherwise>
								</xsl:choose>
								PHYSICIAN_NAMES_READING_STUDY
							</table>
						</td>
						<td align="right" valign="top">
							<table align="right" border="0">
								<tr>
									<td>PAT_NAME</td>
									<td><b>
									<PNAME>
									<xsl:value-of select="DicomAttribute[@tag='00100010']/PersonName[@number='1']/Alphabetic/FamilyName"/>^
									<xsl:value-of select="DicomAttribute[@tag='00100010']/PersonName[@number='1']/Alphabetic/GivenName"/>
									</PNAME></b></td>
								</tr>
								<tr>
									<td>PAT_ID</td>
									<td><b><xsl:value-of select="DicomAttribute[@tag='00100020']/Value[@number='1']"/></b></td>
								</tr>
								<tr>
									<td>PAT_BIRTHDATE</td>
									<td><b><DATE><xsl:value-of select="DicomAttribute[@tag='00100030']/Value[@number='1']"/></DATE></b></td>
								</tr>
								<tr>
									<td>PAT_SEX</td>
									<td><b><xsl:value-of select="DicomAttribute[@tag='00100040']/Value[@number='1']"/></b></td>
								</tr>
							</table>
						</td>
					</tr>
				</table>
				<hr/>
				<br/>
				
				<xsl:variable name="element-language">
					<xsl:call-template name="element-language">
						<xsl:with-param name="node" select="DicomAttribute[@tag='0040A730']"/>
					</xsl:call-template>
				</xsl:variable>

				<xsl:apply-templates select="DicomAttribute[@tag='00400275']/Item" mode="REQ_DicomAttribute_SEQ"/>
				
				<xsl:choose>
					<xsl:when test="DicomAttribute[@tag='0040A050']/Value[@number='1']='CONTINOUS'">
						<xsl:apply-templates select="DicomAttribute[@tag='0040A730']/Item" mode="CONTENT_CONTINOUS">
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:apply-templates>
					</xsl:when>
					<xsl:otherwise>
						<ul>
						<xsl:apply-templates select="DicomAttribute[@tag='0040A730']/Item" mode="CONTENT_SEPARATE">
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:apply-templates>
						</ul>
					</xsl:otherwise>
				</xsl:choose>	
			</body>
    	</html>
	</xsl:template>
	
	<xsl:template match="Item" mode="REQ_DicomAttribute_SEQ">
		<xsl:variable name="ReasonForReqProc" select="DicomAttribute[@tag='00401002']/Value[@number='1']"/>
		<xsl:if test="string-length($ReasonForReqProc)>0">
			<ul><li><u>REASON_FOR_THE_REQ_PROC:</u></li>
			<xsl:value-of select="$ReasonForReqProc"/>
			</ul>
		</xsl:if>
	</xsl:template>	
	
	<xsl:template match="Item" mode="CONTENT">
		<xsl:if test="DicomAttribute[@tag='0040A730']!=''">
			<xsl:variable name="element-language">
				<xsl:call-template name="element-language">
					<xsl:with-param name="node" select="DicomAttribute[@tag='0040A730']"/>
				</xsl:call-template>
			</xsl:variable>
			
			<xsl:choose>
				<xsl:when test="DicomAttribute[@tag='0040A050']/Value[@number='1']='CONTINOUS'">
					<xsl:apply-templates select="DicomAttribute[@tag='0040A730']/Item" mode="CONTENT_CONTINOUS">
						<xsl:with-param name="element-language" select="$element-language"/>
					</xsl:apply-templates>
				</xsl:when>
				<xsl:otherwise>
					<xsl:choose>
						<xsl:when test="$REDUCED_VIEW_PROCESSING='false'">
							<ul>
							<xsl:apply-templates select="DicomAttribute[@tag='0040A730']/Item" mode="SEPARATE_FULL">
								<xsl:with-param name="element-language" select="$element-language"/>
							</xsl:apply-templates>
							</ul>
						</xsl:when>
						<xsl:otherwise>
							<xsl:apply-templates select="DicomAttribute[@tag='0040A730']/Item" mode="SEPARATE_REDUCED">
								<xsl:with-param name="element-language" select="$element-language"/>
							</xsl:apply-templates>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>
	</xsl:template>
	
	
	
	<xsl:template match="Item" mode="CONTENT_CONTINOUS">
		<xsl:param name="element-language"/>
		
		<xsl:choose>
			<xsl:when test="$REDUCED_VIEW_PROCESSING='false'">
				<xsl:call-template name="translate-code">
					<xsl:with-param name="node" select="."/>
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:call-template>
				
				<br/>
				<blockquote>
				<xsl:apply-templates select="current()" mode="CONTINOUS">
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:apply-templates>
				</blockquote>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="current()" mode="CONTINOUS">
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	
	<xsl:template match="Item" mode="CONTENT_SEPARATE">	
		<xsl:param name="element-language"/>
			
		<xsl:choose>
			<xsl:when test="$REDUCED_VIEW_PROCESSING='false'">
				<xsl:apply-templates select="current()" mode="SEPARATE_FULL">
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:apply-templates>
			</xsl:when>
			<xsl:otherwise>
				<xsl:apply-templates select="current()" mode="SEPARATE_REDUCED">
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:apply-templates>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	
	<xsl:template match="Item" mode="SEPARATE_REDUCED">	
		<xsl:param name="element-language"/>
		
		<xsl:variable name="codeValue">
			<xsl:value-of select="DicomAttribute[@tag='0040A043']/Item/DicomAttribute[@tag='00080100']/Value[@number='1']"/>
		</xsl:variable>
		
		<xsl:variable name="isFiltered">
			<xsl:choose>
				<xsl:when test="$codeValue!=''">
					<xsl:value-of select="contains($FILTERED_CODE_VALUES, $codeValue)"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="false()"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
				
		<xsl:choose>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='CONTAINER'">
				<xsl:if test="$isFiltered='false'">
					<xsl:apply-templates select="current()" mode="CONTAINER"/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='TEXT'">				
				<xsl:if test="$isFiltered='false'">			
					<li>
						<u>
						<xsl:call-template name="translate-code">
							<xsl:with-param name="node" select="."/>
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:call-template>
						</u>
						<br/>
						<xsl:apply-templates select="current()" mode="TEXT"/>
					</li>
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='CODE'">
				<xsl:if test="$isFiltered='false'">
					<li>
						<u>
						<xsl:call-template name="translate-code">
							<xsl:with-param name="node" select="."/>
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:call-template>
						</u>
						<br/>
						<xsl:apply-templates select="current()" mode="CODE"/>
					</li>
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='NUM'">
				<xsl:if test="$isFiltered='false'">
					<li>
						<u>
						<xsl:call-template name="translate-code">
							<xsl:with-param name="node" select="."/>
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:call-template>
						</u>
						<br/>
						<xsl:apply-templates select="current()" mode="NUM"/>
					</li>
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='UIDREF'">
				<xsl:if test="$isFiltered='false'">
					<li>
						<u>
						<xsl:call-template name="translate-code">
							<xsl:with-param name="node" select="."/>
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:call-template>
						</u>
						<br/>
						<xsl:apply-templates select="current()" mode="UIDREF"/>
					</li>
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='PNAME'">
				<xsl:if test="$isFiltered='false'">
					<li>
						<u>
						<xsl:call-template name="translate-code">
							<xsl:with-param name="node" select="."/>
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:call-template>					
						</u>
						<br/>
						<xsl:apply-templates select="current()" mode="PNAME"/>
					</li>
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='DATE'">
				<xsl:if test="$isFiltered='false'">
					<li>
						<u>
						<xsl:call-template name="translate-code">
							<xsl:with-param name="node" select="."/>
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:call-template>
						</u>
						<br/>
						<xsl:apply-templates select="current()" mode="DATE"/>
					</li>
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='TIME'">
				<xsl:if test="$isFiltered='false'">
					<li>
						<u>
						<xsl:call-template name="translate-code">
							<xsl:with-param name="node" select="."/>
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:call-template>
						</u>
						<br/>
						<xsl:apply-templates select="current()" mode="TIME"/>
					</li>
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='DATETIME'">
				<xsl:if test="$isFiltered='false'">
					<li>
						<u>
						<xsl:call-template name="translate-code">
							<xsl:with-param name="node" select="."/>
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:call-template>
						</u>
						<br/>
						<xsl:apply-templates select="current()" mode="DATETIME"/>
					</li>
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='COMPOSITE'">
				<xsl:if test="$isFiltered='false'">
					<li>
						<u>
						<xsl:call-template name="translate-code">
							<xsl:with-param name="node" select="."/>
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:call-template>
						</u>
						<br/>
						<xsl:apply-templates select="current()" mode="COMPOSITE"/>
					</li>
					<br/>
				</xsl:if>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='IMAGE'">
				<xsl:apply-templates select="current()" mode="IMAGE"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='WAVEFORM'">
				<xsl:apply-templates select="current()" mode="WAVEFORM"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	<xsl:template match="Item" mode="SEPARATE_FULL">
		<xsl:param name="element-language"/>
				
		<xsl:choose>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='CONTAINER'">
				<xsl:choose>
					<xsl:when test="$REDUCED_VIEW_PROCESSING='false'">
						<li>
						<xsl:call-template name="translate-code">
							<xsl:with-param name="node" select="."/>
							<xsl:with-param name="element-language" select="$element-language"/>
						</xsl:call-template>
						<br/>
						<xsl:apply-templates select="current()" mode="CONTAINER"/>
						</li>
					</xsl:when>
					<xsl:otherwise>
						<xsl:apply-templates select="current()" mode="CONTAINER"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='TEXT'">
				<li>
				<xsl:call-template name="translate-code">
					<xsl:with-param name="node" select="."/>
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:call-template>
				<xsl:apply-templates select="current()" mode="TEXT"/>
				</li>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='CODE'">
				<li>
				<xsl:call-template name="translate-code">
					<xsl:with-param name="node" select="."/>
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:call-template>
				<xsl:apply-templates select="current()" mode="CODE"/>
				</li>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='NUM'">
				<li>
				<xsl:call-template name="translate-code">
					<xsl:with-param name="node" select="."/>
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:call-template>
				<xsl:apply-templates select="current()" mode="NUM"/>
				</li>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='UIDREF'">
				<li>
				<xsl:call-template name="translate-code">
					<xsl:with-param name="node" select="."/>
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:call-template>
				<xsl:apply-templates select="current()" mode="UIDREF"/>
				</li>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='PNAME'">
				<li>
				<xsl:call-template name="translate-code">
					<xsl:with-param name="node" select="."/>
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:call-template>
				<xsl:apply-templates select="current()" mode="PNAME"/>
				</li>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='DATE'">
				<li>
				<xsl:call-template name="translate-code">
					<xsl:with-param name="node" select="."/>
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:call-template>
				<xsl:apply-templates select="current()" mode="DATE"/>
				</li>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='TIME'">
				<li>
				<xsl:call-template name="translate-code">
					<xsl:with-param name="node" select="."/>
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:call-template>
				<xsl:apply-templates select="current()" mode="TIME"/>
				</li>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='DATETIME'">
				<li>
				<xsl:call-template name="translate-code">
					<xsl:with-param name="node" select="."/>
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:call-template>
				<xsl:apply-templates select="current()" mode="DATETIME"/>
				</li>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='COMPOSITE'">
				<li>
				<xsl:call-template name="translate-code">
					<xsl:with-param name="node" select="."/>
					<xsl:with-param name="element-language" select="$element-language"/>
				</xsl:call-template>
				<xsl:apply-templates select="current()" mode="COMPOSITE"/>
				</li>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='IMAGE'">
				<xsl:apply-templates select="current()" mode="IMAGE"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='WAVEFORM'">
				<xsl:apply-templates select="current()" mode="WAVEFORM"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	
	<xsl:template match="Item" mode="CONTINOUS">
		<xsl:choose>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='CONTAINER'">
				<xsl:apply-templates select="current()" mode="CONTAINER"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='TEXT'">
				<xsl:apply-templates select="current()" mode="TEXT"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='CODE'">
				<xsl:apply-templates select="current()" mode="CODE"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='NUM'">
				<xsl:apply-templates select="current()" mode="NUM"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='UIDREF'">
				<xsl:apply-templates select="current()" mode="UIDREF"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='PNAME'">
				<xsl:apply-templates select="current()" mode="PNAME"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='DATE'">
				<xsl:apply-templates select="current()" mode="DATE"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='TIME'">
				<xsl:apply-templates select="current()" mode="TIME"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='DATETIME'">
				<xsl:apply-templates select="current()" mode="DATETIME"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='COMPOSITE'">
				<xsl:apply-templates select="current()" mode="COMPOSITE"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='IMAGE'">
				<xsl:apply-templates select="current()" mode="IMAGE"/>
			</xsl:when>
			<xsl:when test="DicomAttribute[@tag='0040A040']/Value[@number='1']='WAVEFORM'">
				<xsl:apply-templates select="current()" mode="WAVEFORM"/>
			</xsl:when>
		</xsl:choose>
	</xsl:template>
	
	
	<!-- VALUE TYPE: "CONTAINER" -->
	<xsl:template match="Item" mode="CONTAINER">
		<xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
	
	
	<!-- VALUE TYPE: "TEXT" -->
	<xsl:template match="Item" mode="TEXT">
		<xsl:variable name="text">
			<xsl:value-of select="DicomAttribute[@tag='0040A160']/Value[@number='1']"/>
		</xsl:variable>
		<b>
		<xsl:call-template name="replace-newline">
			<xsl:with-param name="raw" select="$text" />
		</xsl:call-template>
		</b>
		<xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
		
	
	<!-- VALUE TYPE: "CODE" -->
	<xsl:template match="Item" mode="CODE">
		<b>
		<xsl:value-of select="DicomAttribute[@tag='0040A168']/Item/DicomAttribute[@tag='00080104']/Value[@number='1']"/>
		</b>
		<xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
	
	
	<!-- VALUE TYPE: "NUM" -->
	<xsl:template match="Item" mode="NUM">
		<b>
		<xsl:value-of select="DicomAttribute[@tag='0040A300']/Item/DicomAttribute[@tag='0040A30A']/Value[@number='1']"/>
		&#160;
		<xsl:value-of select="DicomAttribute[@tag='0040A300']/Item/DicomAttribute[@tag='004008EA']/Item/DicomAttribute[@tag='00080104']/Value[@number='1']"/>
		</b>
		<xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
	
	
	<!-- VALUE TYPE: "UIDREF" -->
	<xsl:template match="Item" mode="UIDREF">
		<b><xsl:value-of select="DicomAttribute[@tag='0040A124']/Value[@number='1']"/></b>
		<xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
	
	
	<!-- VALUE TYPE: "PNAME"
		 This is the first out of two steps of PNAME conversion: Reading the name string. This
		 conversion relies on a second processing step in order to convert the Dicom PNAME string
		 into a human readable representation.
	-->
	<xsl:template match="Item" mode="PNAME">
		<b><PNAME>
		<xsl:value-of select="DicomAttribute[@tag='0040A123']/PersonName[@number='1']/Alphabetic/FamilyName"/>
		<xsl:value-of select="DicomAttribute[@tag='0040A123']/PersonName[@number='1']/Alphabetic/GivenName"/>
		</PNAME></b>
		<xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
	
	
	<!-- VALUE TYPE: "DATE"
		 This is the first out of two steps of DATE conversion: Reading the date string. This
		 conversion relies on a second processing step in order to convert the Dicom date string
		 into a human readable localized representation.
	-->
	<xsl:template match="Item" mode="DATE">
		 <b><DATE><xsl:value-of select="DicomAttribute[@tag='0040A121']/Value[@number='1']"/></DATE></b>
		 <xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
	
	
	<!-- VALUE TYPE: "TIME"
		 This is the first out of two steps of TIME conversion: Reading the time string. This
		 conversion relies on a second processing step in order to convert the Dicom time string
		 into a human readable localized representation.
	-->
	<xsl:template match="Item" mode="TIME">
		<b><TIME><xsl:value-of select="DicomAttribute[@tag='0040A122']/Value[@number='1']"/></TIME></b>
		<xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
	
	
	<!-- VALUE TYPE: "DATETIME"
		 This is the first out of two steps of DATETIME conversion: Reading the datetime string. This
		 conversion relies on a second processing step in order to convert the Dicom datetime string
		 into a human readable localized representation.
	-->
	<xsl:template match="Item" mode="DATETIME">
		<b><DATETIME><xsl:value-of select="DicomAttribute[@tag='0040A120']/Value[@number='1']"/></DATETIME></b>
		<xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
	
	
	<!-- VALUE TYPE: "COMPOSITE"
		 This is the first out of two steps of COMPOSITE conversion: Reading the composite properties. This
		 conversion relies on a second processing step in order to convert the composite properties
		 into a human readable localized representation. Either by simply rendering the class/instance UIDs
		 or providing a link to the reference composite.
	-->
	<xsl:template match="Item" mode="COMPOSITE">
		<COMPOSITE>
			<SOP_CLASS_UID><xsl:value-of select="DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='00081150']/Value[@number='1']"/></SOP_CLASS_UID>
			<SOP_INSTANCE_UID><xsl:value-of select="DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='00081155']/Value[@number='1']"/></SOP_INSTANCE_UID>
		</COMPOSITE>
		<xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
	
	
	<!-- VALUE TYPE: "WAVEFORM"
		 This is the first out of two steps of WAVEFORM conversion: Reading the waveform string properties. This
		 conversion relies on a second processing step in order to convert the waveform properties
		 into a usable/rendered localized representation.
	-->
	<xsl:template match="Item" mode="WAVEFORM">
		<WAVEFORM>
			<SOP_CLASS_UID><xsl:value-of select="DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='00081150']/Value[@number='1']"/></SOP_CLASS_UID>
			<SOP_INSTANCE_UID><xsl:value-of select="DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='00081155']/Value[@number='1']"/></SOP_INSTANCE_UID>
			<CHANNELS><xsl:value-of select="DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='0008A0B0']/Value[@number='1']"/></CHANNELS>
		</WAVEFORM>
		<xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
	
	
	<!-- VALUE TYPE: "IMAGE"
		 This is the first out of two steps of IMAGE conversion: Reading the image properties. This
		 conversion relies on a second processing step in order to convert the image properties
		 into a usable/rendered localized image representation.
	-->
	<xsl:template match="Item" mode="IMAGE">
		<IMAGE>
			<SOP_CLASS_UID><xsl:value-of select="DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='00081150']/Value[@number='1']"/></SOP_CLASS_UID>
			<SOP_INSTANCE_UID><xsl:value-of select="DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='00081155']/Value[@number='1']"/></SOP_INSTANCE_UID>
			<FRAME_NUMBERS><xsl:value-of select="DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='00081160']/Value[@number='1']"/></FRAME_NUMBERS>
			<PS_SOP_CLASS_UID><xsl:value-of select="DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='00081150']/Value[@number='1']"/></PS_SOP_CLASS_UID>
			<PS_SOP_INSTANCE_UID><xsl:value-of select="DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='00081199']/Item/DicomAttribute[@tag='00081155']/Value[@number='1']"/></PS_SOP_INSTANCE_UID>
		</IMAGE>
		<xsl:apply-templates select="current()" mode="CONTENT"/>
	</xsl:template>
	
	
	
	
	<!-- ************ HELPER templates ************ -->
	
	
	<!--template that handles replace-recursion-->
	<xsl:template name="replace-newline">
		<xsl:param name="raw" />
		<xsl:variable name="linefeed"><xsl:text>&#x0a;</xsl:text></xsl:variable>
		<xsl:choose>
			<xsl:when test="contains($raw,$linefeed)">
				<xsl:value-of select="substring-before($raw,$linefeed)"/>
				<p>
				<xsl:call-template name="replace-newline">
					<xsl:with-param name="raw" select="substring-after($raw,$linefeed)" />
				</xsl:call-template>
				</p>
			</xsl:when>
			<xsl:when test="string-length($raw) != 0">
				<xsl:value-of select="$raw" />
			</xsl:when>
			<xsl:otherwise/>
		</xsl:choose>
	</xsl:template>
	
	
	<xsl:template name="translate-code">
		<xsl:param name="node"/>
		<xsl:param name="element-language"/>

		<xsl:variable name="concept-name-meaning">
			<xsl:call-template name="find-concept-name-meaning">
				<xsl:with-param name="node" select="$node"/>
			</xsl:call-template>
		</xsl:variable>
		
		<xsl:variable name="concept-name-value">
			<xsl:call-template name="find-concept-name-value">
				<xsl:with-param name="node" select="$node"/>
			</xsl:call-template>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="$LANGUAGE=$element-language">
				<xsl:value-of select="$concept-name-meaning"/>
			</xsl:when>
			<xsl:otherwise>
				<TRANSLATE-CODE>
				<VALUE><xsl:value-of select="$concept-name-value"/></VALUE>
				<DEFAULT><xsl:value-of select="$concept-name-meaning"/></DEFAULT>
				</TRANSLATE-CODE>
			</xsl:otherwise>
		</xsl:choose>
		
		:
	</xsl:template>
	
	
	<xsl:template name="find-concept-name-meaning">
		<xsl:param name="node"/>
		
		<xsl:choose>
			<xsl:when test="not($node)">
			</xsl:when>
			<xsl:when test="not($node/DicomAttribute[@tag='0040A043'])">
				<xsl:call-template name="find-concept-name-meaning">
					<xsl:with-param name="node" select="$node/.."/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$node/DicomAttribute[@tag='0040A043']/Item/DicomAttribute[@tag='00080104']"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	
	<xsl:template name="find-concept-name-value">
		<xsl:param name="node"/>
		
		<xsl:choose>
			<xsl:when test="not($node)">
			</xsl:when>
			<xsl:when test="not($node/DicomAttribute[@tag='0040A043'])">
				<xsl:call-template name="find-concept-name-value">
					<xsl:with-param name="node" select="$node/.."/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$node/DicomAttribute[@tag='0040A043']/Item/DicomAttribute[@tag='00080100']"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	
	
	<xsl:template name="element-language">
		<xsl:param name="node"/>
		
		<xsl:for-each select="$node/Item">
			<xsl:variable name="codeValue" select="DicomAttribute[@tag='0040A043']/Item/DicomAttribute[@tag='00080100']"/>
			
			<xsl:if test="$codeValue='121049'">
				<xsl:value-of select="DicomAttribute[@tag='0040A168']/Item/DicomAttribute[@tag='00080100']"/>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
</xsl:stylesheet>