/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject;

import com.agfa.pacs.listtext.dicomobject.IModuleContainer;
import com.agfa.pacs.listtext.dicomobject.module.IModule;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;

public class ModuleContainer
implements IModuleContainer {
    private static final ALogger LOGGER = ALogger.getLogger(ModuleContainer.class);
    protected Map<Class<? extends IModule>, IModule> modules = new Hashtable<Class<? extends IModule>, IModule>();
    private List<Class<? extends IModule>> moduleClasses = new ArrayList<Class<? extends IModule>>();
    private boolean modified = false;

    public ModuleContainer() {
    }

    public ModuleContainer(Class<? extends IModule>[] classArray) {
        this();
        Class<? extends IModule>[] classArray2 = classArray;
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends IModule> clazz = classArray2[n2];
            this.moduleClasses.add(clazz);
            try {
                this.setModule(clazz.newInstance());
            }
            catch (Exception exception) {
                LOGGER.error("Setting module failed: " + clazz, (Throwable)exception);
            }
            ++n2;
        }
    }

    @Override
    public synchronized void setModule(IModule iModule) {
        if (iModule == null) {
            return;
        }
        this.modules.put(iModule.getClass(), iModule);
    }

    @Override
    public synchronized void removeModule(Class<? extends IModule> clazz) {
        this.modules.remove(clazz);
    }

    @Override
    public synchronized void removeObject(Class<? extends Object> clazz) {
        this.modules.remove(clazz);
    }

    @Override
    public synchronized void setModules(List<IModule> list) {
        for (IModule iModule : list) {
            this.setModule(iModule);
        }
    }

    @Override
    public synchronized <U extends IModule> U getModule(Class<U> clazz) {
        return (U)this.modules.get(clazz);
    }

    @Override
    public synchronized <U extends IModule> U getModuleCreate(Class<U> clazz) {
        if (!this.modules.containsKey(clazz)) {
            try {
                IModule iModule = (IModule)clazz.newInstance();
                iModule.hasContent(true);
                this.modules.put(clazz, iModule);
            }
            catch (Exception exception) {
                LOGGER.error("Creating module of type " + clazz + " failed.", (Throwable)exception);
            }
        }
        return (U)this.modules.get(clazz);
    }

    @Override
    public synchronized <U extends IModule> U getModuleCreate(Class<U> clazz, Attributes attributes) {
        if (!this.modules.containsKey(clazz)) {
            try {
                IModule iModule = (IModule)clazz.newInstance();
                if (iModule.containsModule(attributes)) {
                    iModule.readFrom(attributes);
                }
                iModule.hasContent(true);
                this.modules.put(clazz, (IModule)clazz.newInstance());
            }
            catch (Exception exception) {
                LOGGER.error("Creating module of type " + clazz + " failed.", (Throwable)exception);
            }
        }
        return (U)this.modules.get(clazz);
    }

    @Override
    public synchronized <U> U getObject(Class<U> clazz) {
        for (IModule iModule : this.modules.values()) {
            if (!clazz.isInstance(iModule)) continue;
            return (U)iModule;
        }
        return null;
    }

    @Override
    public synchronized List<IModule> getModules() {
        return new ArrayList<IModule>(this.modules.values());
    }

    @Override
    public synchronized void fromDataset(Attributes attributes) {
        for (IModule iModule : this.modules.values()) {
            if (!iModule.containsModule(attributes)) continue;
            iModule.readFrom(attributes);
            iModule.hasContent(true);
        }
    }

    @Override
    public synchronized Attributes toDataset() {
        ArrayList<IModule> arrayList = new ArrayList<IModule>();
        Attributes attributes = new Attributes();
        for (IModule iModule : this.modules.values()) {
            this.writeModule(attributes, iModule, arrayList);
        }
        return attributes;
    }

    protected void writeModule(Attributes attributes, IModule iModule, List<IModule> list) {
        if (iModule == null) {
            return;
        }
        if (list.contains(iModule)) {
            return;
        }
        if (!iModule.hasContent()) {
            return;
        }
        if (iModule.specializationOf() != null) {
            Class[] classArray = iModule.specializationOf();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class clazz = classArray[n2];
                Object u = this.getModule(clazz);
                this.writeModule(attributes, (IModule)u, list);
                ++n2;
            }
        }
        iModule.writeTo(attributes);
        list.add(iModule);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("\n");
        for (IModule iModule : this.getModules()) {
            stringBuilder.append(" ");
            stringBuilder.append(iModule.getClass().getName());
            stringBuilder.append(" ");
            stringBuilder.append(iModule.hasContent());
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified() {
        this.modified = true;
    }

    public void setUnmodified() {
        this.modified = false;
    }
}

