/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.DicomInformationObject;
import com.agfa.pacs.listtext.dicomobject.IInformationObjectProvider;
import com.agfa.pacs.listtext.dicomobject.IModuleContainer;
import com.agfa.pacs.listtext.dicomobject.module.IModule;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.eclipse.core.runtime.IConfigurationElement;

public class InformationObjectProviderEclipseImpl
implements IInformationObjectProvider {
    private String className;
    private IConfigurationElement configElement;
    private List<String> classUIDs;
    private List<ModuleConfig> moduleConfigs;
    private Map<String, Class> classMap;
    private ALogger log = ALogger.getLogger(InformationObjectProviderEclipseImpl.class);

    public InformationObjectProviderEclipseImpl(IConfigurationElement iConfigurationElement) {
        this.configElement = iConfigurationElement;
        this.className = iConfigurationElement.getAttribute("class");
        IConfigurationElement[] iConfigurationElementArray = iConfigurationElement.getChildren();
        this.classUIDs = new ArrayList<String>();
        this.moduleConfigs = new ArrayList<ModuleConfig>();
        this.classMap = Collections.synchronizedMap(new HashMap());
        IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement iConfigurationElement2 = iConfigurationElementArray2[n2];
            if ("dicom".equals(iConfigurationElement2.getName())) {
                this.classUIDs.add(iConfigurationElement2.getAttribute("classUID"));
            }
            if ("module".equals(iConfigurationElement2.getName())) {
                this.moduleConfigs.add(new ModuleConfig(iConfigurationElement2));
            }
            ++n2;
        }
    }

    @Override
    public List<String> getClassUIDs() {
        return this.classUIDs;
    }

    @Override
    public DicomInformationObject createInformationObject(IModuleContainer iModuleContainer) {
        DicomInformationObject dicomInformationObject = (DicomInformationObject)this.createClass(this.className, this.configElement);
        for (ModuleConfig moduleConfig : this.moduleConfigs) {
            IModule iModule = (IModule)this.createClass(moduleConfig.className, moduleConfig.configElement);
            if (iModule == null) continue;
            iModule.hasContent(moduleConfig.mandatory);
            if (iModuleContainer != null) {
                Object obj = iModuleContainer.getModule(iModule.getClass());
                if (obj != null) {
                    this.copyModuleContent((IModule)obj, iModule);
                    if (obj.hasContent()) {
                        iModule.hasContent(true);
                    }
                } else if (iModule.specializationOf() != null) {
                    Class[] classArray = iModule.specializationOf();
                    int n = classArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class clazz = classArray[n2];
                        Object u = iModuleContainer.getModule(clazz);
                        if (u != null) {
                            this.copyModuleContent((IModule)u, iModule);
                            if (u.hasContent()) {
                                iModule.hasContent(true);
                            }
                        }
                        ++n2;
                    }
                }
            }
            dicomInformationObject.setModule(iModule);
        }
        dicomInformationObject.init(true);
        return dicomInformationObject;
    }

    @Override
    public DicomInformationObject createInformationObject(Map<Level, Attributes> map, boolean bl) {
        DicomInformationObject dicomInformationObject = (DicomInformationObject)this.createClass(this.className, this.configElement);
        for (ModuleConfig moduleConfig : this.moduleConfigs) {
            Attributes attributes;
            IModule iModule = (IModule)this.createClass(moduleConfig.className, moduleConfig.configElement);
            if (iModule == null || (attributes = map.get(iModule.getLevel())) == null || !iModule.containsModule(attributes) && !moduleConfig.mandatory) continue;
            iModule.readFrom(attributes);
            dicomInformationObject.setModule(iModule);
            iModule.hasContent(true);
        }
        dicomInformationObject.init(bl);
        return dicomInformationObject;
    }

    @Override
    public DicomInformationObject createInformationObject(Attributes attributes, boolean bl) {
        DicomInformationObject dicomInformationObject = (DicomInformationObject)this.createClass(this.className, this.configElement);
        for (ModuleConfig moduleConfig : this.moduleConfigs) {
            IModule iModule = (IModule)this.createClass(moduleConfig.className, moduleConfig.configElement);
            if (iModule == null || !iModule.containsModule(attributes) && !moduleConfig.mandatory) continue;
            iModule.readFrom(attributes);
            dicomInformationObject.setModule(iModule);
            iModule.hasContent(true);
        }
        dicomInformationObject.init(bl);
        return dicomInformationObject;
    }

    @Override
    public DicomInformationObject createInformationObject() {
        DicomInformationObject dicomInformationObject = (DicomInformationObject)this.createClass(this.className, this.configElement);
        for (ModuleConfig moduleConfig : this.moduleConfigs) {
            IModule iModule = (IModule)this.createClass(moduleConfig.className, moduleConfig.configElement);
            if (iModule == null) continue;
            iModule.hasContent(moduleConfig.mandatory);
            dicomInformationObject.setModule(iModule);
        }
        dicomInformationObject.init(true);
        return dicomInformationObject;
    }

    private void copyModuleContent(IModule iModule, IModule iModule2) {
        Attributes attributes = new Attributes();
        iModule.writeTo(attributes);
        iModule2.readFrom(attributes);
    }

    private <U> U createClass(String string, IConfigurationElement iConfigurationElement) {
        if (!this.classMap.containsKey(string)) {
            try {
                Object object = iConfigurationElement.createExecutableExtension("class");
                this.classMap.put(string, object.getClass());
                return (U)object;
            }
            catch (Exception exception) {
                this.classMap.put(string, null);
                this.log.warn("class " + string + ": " + exception.getMessage());
            }
        } else {
            try {
                Class clazz = this.classMap.get(string);
                if (clazz != null) {
                    return (U)clazz.newInstance();
                }
            }
            catch (Exception exception) {
                this.log.error("class creation", (Throwable)exception);
            }
        }
        return null;
    }

    private static class ModuleConfig {
        public final String className;
        public final boolean mandatory;
        public final IConfigurationElement configElement;

        public ModuleConfig(IConfigurationElement iConfigurationElement) {
            String string = iConfigurationElement.getAttribute("mandatory");
            this.className = iConfigurationElement.getAttribute("class");
            this.mandatory = string != null ? "true".equals(string) : false;
            this.configElement = iConfigurationElement;
        }
    }
}

