/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.type.print;

import com.agfa.pacs.data.shared.dicom.DicomEnum;
import java.util.List;
import java.util.Vector;

public class FilmSizeID
implements DicomEnum {
    private static List<FilmSizeID> values;
    public static final FilmSizeID _8in_10in;
    public static final FilmSizeID _8p5in_10in;
    public static final FilmSizeID _10in_12in;
    public static final FilmSizeID _10in_14in;
    public static final FilmSizeID _11in_14in;
    public static final FilmSizeID _11in_17in;
    public static final FilmSizeID _14in_14in;
    public static final FilmSizeID _14in_17in;
    public static final FilmSizeID _24cm_24cm;
    public static final FilmSizeID _24cm_30cm;
    public static final FilmSizeID A4;
    public static final FilmSizeID A3;
    private final String dicomId;
    private final double width;
    private final double height;

    static {
        _8in_10in = new FilmSizeID("8INX10IN", 8.0, 10.0, true, true);
        _8p5in_10in = new FilmSizeID("8_5INX10IN", 8.5, 10.0, true, true);
        _10in_12in = new FilmSizeID("10INX12IN", 10.0, 12.0, true, true);
        _10in_14in = new FilmSizeID("10INX14IN", 10.0, 14.0, true, true);
        _11in_14in = new FilmSizeID("11INX14IN", 11.0, 14.0, true, true);
        _11in_17in = new FilmSizeID("11INX17IN", 11.0, 17.0, true, true);
        _14in_14in = new FilmSizeID("14INX14IN", 14.0, 14.0, true, true);
        _14in_17in = new FilmSizeID("14INX17IN", 14.0, 17.0, true, true);
        _24cm_24cm = new FilmSizeID("24CMX24CM", 240.0, 240.0, false, true);
        _24cm_30cm = new FilmSizeID("24CMX30CM", 240.0, 300.0, false, true);
        A4 = new FilmSizeID("A4", 210.0, 297.0, false, true);
        A3 = new FilmSizeID("A3", 297.0, 420.0, false, true);
    }

    public FilmSizeID(String string, double d, double d2, boolean bl) {
        this(string, d, d2, bl, false);
    }

    private FilmSizeID(String string, double d, double d2, boolean bl, boolean bl2) {
        this.dicomId = string;
        this.width = bl ? d * 25.4 : d;
        double d3 = this.height = bl ? d2 * 25.4 : d2;
        if (values == null) {
            values = new Vector<FilmSizeID>();
        }
        if (bl2) {
            values.add(this);
        }
    }

    public String dicom() {
        return this.dicomId;
    }

    public double getHeight() {
        return this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public static FilmSizeID get(String string) {
        for (FilmSizeID filmSizeID : values) {
            if (!filmSizeID.dicom().equals(string)) continue;
            return filmSizeID;
        }
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilmSizeID)) {
            return false;
        }
        FilmSizeID filmSizeID = (FilmSizeID)object;
        return this.dicomId.equals(filmSizeID.dicomId);
    }

    public int hashCode() {
        return this.dicomId == null ? 0 : this.dicomId.hashCode();
    }
}

