/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.sr;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.interfaces.ISeriesIdentifier;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.IModule;
import com.agfa.pacs.listtext.dicomobject.module.series.GeneralSeriesModule;
import org.dcm4che3.data.Attributes;

public class SRDocumentSeriesModule
extends AbstractModule
implements ISeriesIdentifier {
    private String modality = "SR";
    private String seriesInstanceUID;
    private Integer seriesNumber;
    private ReferencedSOP referencedPerformedProcedureStep;

    public SRDocumentSeriesModule() {
        super(Level.Series);
    }

    @Override
    public Class<? extends IModule>[] specializationOf() {
        return new Class[]{GeneralSeriesModule.class};
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return "SR".equals(this.getString(attributes, 524384));
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.modality = this.getString(attributes, 524384);
        this.seriesInstanceUID = this.getString(attributes, 0x20000E);
        this.seriesNumber = this.getInteger(attributes, 0x200011);
        this.referencedPerformedProcedureStep = ReferencedSOP.create(attributes.getNestedDataset(528657));
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.modality, attributes, 524384, DatasetAccessor.Type.Mandatory);
        this.set(this.seriesInstanceUID, attributes, 0x20000E, DatasetAccessor.Type.Mandatory);
        this.set(this.seriesNumber, attributes, 0x200011, DatasetAccessor.Type.Mandatory);
        this.set((DatasetSource)this.referencedPerformedProcedureStep, attributes, 528657, DatasetAccessor.Type.MandatoryOrEmpty);
    }

    @Override
    public String getModality() {
        return this.modality;
    }

    @Override
    public ReferencedSOP getReferencedPerformedProcedureStep() {
        return this.referencedPerformedProcedureStep;
    }

    @Override
    public String getSeriesInstanceUID() {
        return this.seriesInstanceUID;
    }

    @Override
    public Integer getSeriesNumber() {
        return this.seriesNumber;
    }

    @Override
    public void setModality(String string) {
        this.modality = string;
    }

    @Override
    public void setReferencedPerformedProcedureStep(ReferencedSOP referencedSOP) {
        this.referencedPerformedProcedureStep = referencedSOP;
    }

    @Override
    public void setSeriesInstanceUID(String string) {
        this.seriesInstanceUID = string;
    }

    @Override
    public void setSeriesNumber(Integer n) {
        this.seriesNumber = n;
    }
}

