/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.HorizontalJustification;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class TextObject
extends AbstractDatasetSource {
    private YN anchorPointVisiblity;
    private YN scaleTextToBoundingBox;
    private float[] anchorPoint;
    private HorizontalJustification boundingBoxTextHorizontalJustification;
    private AnnotationUnits boundingBoxAnnotationUnits;
    private AnnotationUnits anchorPointAnnotationUnits;
    private String unformattedTextValue;
    private float[] boundingBoxTopLeftHandCorner;
    private float[] boundingBoxBottomRightHandCorner;
    private String tianiROIID;

    public TextObject() {
    }

    private TextObject(Attributes attributes) {
        this.boundingBoxAnnotationUnits = AnnotationUnits.get(this.getString(attributes, 0x700003));
        this.anchorPointAnnotationUnits = AnnotationUnits.get(this.getString(attributes, 0x700004));
        this.unformattedTextValue = this.getString(attributes, 0x700006);
        this.boundingBoxTopLeftHandCorner = this.getFloats(attributes, 0x700010);
        this.boundingBoxBottomRightHandCorner = this.getFloats(attributes, 0x700011);
        this.boundingBoxTextHorizontalJustification = HorizontalJustification.get(this.getString(attributes, 7340050));
        this.anchorPoint = this.getFloats(attributes, 7340052);
        this.anchorPointVisiblity = YN.get(this.getString(attributes, 7340053));
        this.scaleTextToBoundingBox = YN.get(this.getString(attributes, 7405654));
        this.tianiROIID = attributes.getString("TIANI", 0x710010);
        if (this.tianiROIID == null) {
            this.tianiROIID = attributes.getString(0x711010, null);
        }
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.boundingBoxAnnotationUnits, attributes, 0x700003, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.anchorPointAnnotationUnits, attributes, 0x700004, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.unformattedTextValue, attributes, 0x700006, DatasetAccessor.Type.Mandatory);
        this.set(this.boundingBoxTopLeftHandCorner, attributes, 0x700010, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.boundingBoxBottomRightHandCorner, attributes, 0x700011, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.boundingBoxTextHorizontalJustification, attributes, 7340050, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.anchorPoint, attributes, 7340052, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.anchorPointVisiblity, attributes, 7340053, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.scaleTextToBoundingBox, attributes, 7405654, DatasetAccessor.Type.ConditionalMandatory);
        if (this.tianiROIID != null) {
            attributes.setString("TIANI", 0x710010, VR.CS, this.tianiROIID);
        }
        return attributes;
    }

    public static TextObject create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x700006)) {
            return new TextObject(attributes);
        }
        return null;
    }

    public static List<TextObject> createList(Attributes attributes, int n) {
        Sequence sequence = attributes.getSequence(n);
        ArrayList<TextObject> arrayList = new ArrayList<TextObject>();
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            TextObject textObject = TextObject.create((Attributes)sequence.get(n2));
            if (textObject != null) {
                arrayList.add(textObject);
            }
            ++n2;
        }
        return arrayList;
    }

    public float[] getAnchorPoint() {
        return this.anchorPoint;
    }

    public AnnotationUnits getAnchorPointAnnotationUnits() {
        return this.anchorPointAnnotationUnits;
    }

    public YN getAnchorPointVisiblity() {
        return this.anchorPointVisiblity;
    }

    public AnnotationUnits getBoundingBoxAnnotationUnits() {
        return this.boundingBoxAnnotationUnits;
    }

    public float[] getBoundingBoxBottomRightHandCorner() {
        return this.boundingBoxBottomRightHandCorner;
    }

    public HorizontalJustification getBoundingBoxTextHorizontalJustification() {
        return this.boundingBoxTextHorizontalJustification;
    }

    public float[] getBoundingBoxTopLeftHandCorner() {
        return this.boundingBoxTopLeftHandCorner;
    }

    public String getUnformattedTextValue() {
        return this.unformattedTextValue;
    }

    public String getTianiROIID() {
        return this.tianiROIID;
    }

    public YN getScaleTextToBoundingBox() {
        return this.scaleTextToBoundingBox;
    }

    public void setAnchorPoint(float[] fArray) {
        this.anchorPoint = fArray;
    }

    public void setAnchorPointAnnotationUnits(AnnotationUnits annotationUnits) {
        this.anchorPointAnnotationUnits = annotationUnits;
    }

    public void setAnchorPointVisiblity(YN yN) {
        this.anchorPointVisiblity = yN;
    }

    public void setBoundingBoxAnnotationUnits(AnnotationUnits annotationUnits) {
        this.boundingBoxAnnotationUnits = annotationUnits;
    }

    public void setBoundingBoxBottomRightHandCorner(float[] fArray) {
        this.boundingBoxBottomRightHandCorner = fArray;
    }

    public void setBoundingBoxTextHorizontalJustification(HorizontalJustification horizontalJustification) {
        this.boundingBoxTextHorizontalJustification = horizontalJustification;
    }

    public void setBoundingBoxTopLeftHandCorner(float[] fArray) {
        this.boundingBoxTopLeftHandCorner = fArray;
    }

    public void setScaleTextToBoundingBox(YN yN) {
        this.scaleTextToBoundingBox = yN;
    }

    public void setTianiROIID(String string) {
        this.tianiROIID = string;
    }

    public void setUnformattedTextValue(String string) {
        this.unformattedTextValue = string;
    }
}

