/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.lut.DicomLookupTable;
import com.agfa.pacs.listtext.dicomobject.lut.ILookupTable;
import com.agfa.pacs.listtext.dicomobject.lut.ILookupTableSource;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import org.dcm4che3.data.Attributes;

public class PresentationLookupTable
extends AbstractDatasetSource
implements ILookupTableSource {
    protected String lutExplanation;
    protected int[] lutDescriptor;
    protected byte[] lutData;

    public PresentationLookupTable() {
    }

    private PresentationLookupTable(Attributes attributes) {
        this.lutDescriptor = PresentationLookupTable.getLUTDescriptor((Attributes)attributes);
        this.lutExplanation = this.getString(attributes, 2633731);
        try {
            this.lutData = attributes.getBytes(2633734);
        }
        catch (IOException iOException) {
            ALogger.getLogger(PresentationLookupTable.class).error("Bulk error", (Throwable)iOException);
        }
    }

    public static PresentationLookupTable create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(2633730)) {
            return new PresentationLookupTable(attributes);
        }
        return null;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.lutDescriptor, attributes, 2633730, DatasetAccessor.Type.Mandatory);
        this.set(this.lutExplanation, attributes, 2633731, DatasetAccessor.Type.Optional);
        this.set(this.lutData, attributes, 2633734, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public void setLUTData(byte[] byArray) {
        this.lutData = byArray;
    }

    public void setLUTDescriptor(int[] nArray) {
        this.lutDescriptor = nArray;
    }

    @Override
    public ILookupTable getLookupTable() {
        return new DicomLookupTable(this.lutDescriptor, this.lutData, null, this.lutExplanation);
    }

    @Override
    public boolean hasLookupTable() {
        return this.lutDescriptor != null;
    }
}

