/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import com.agfa.pacs.listtext.dicomobject.type.GraphicType;
import com.agfa.pacs.listtext.dicomobject.type.TianiSubType;
import com.agfa.pacs.listtext.dicomobject.type.YN;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;

public class GraphicObject
extends AbstractDatasetSource {
    private YN graphicFilled;
    private GraphicType graphicType;
    private float[] graphicData;
    private Integer numberOfGraphicPoints;
    private Integer graphicDimensions;
    private AnnotationUnits graphicAnnotationUnits;
    private String tianiROIID;
    private TianiSubType tianiSubType;
    private String tianiID;
    private double[] tianiPositionData;

    public GraphicObject() {
    }

    private GraphicObject(Attributes attributes) {
        this.graphicAnnotationUnits = AnnotationUnits.get(this.getString(attributes, 0x700005));
        this.graphicDimensions = this.getInteger(attributes, 0x700020);
        this.numberOfGraphicPoints = this.getInteger(attributes, 7340065);
        this.graphicData = this.getFloats(attributes, 0x700022);
        this.graphicType = GraphicType.get(this.getString(attributes, 7340067));
        this.graphicFilled = YN.get(this.getString(attributes, 7340068));
        this.tianiROIID = attributes.getString("TIANI", 0x710010);
        if (this.tianiROIID == null) {
            this.tianiROIID = attributes.getString(0x711010);
        }
        this.tianiSubType = TianiSubType.get(attributes.getString("TIANI", 7405603));
        if (this.tianiSubType == null) {
            this.tianiSubType = TianiSubType.get(attributes.getString(7409699));
        }
        this.tianiPositionData = attributes.getDoubles("TIANI", 7405616);
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.graphicAnnotationUnits, attributes, 0x700005, DatasetAccessor.Type.Mandatory);
        this.set(this.graphicDimensions, attributes, 0x700020, DatasetAccessor.Type.Mandatory);
        this.set(this.numberOfGraphicPoints, attributes, 7340065, DatasetAccessor.Type.Mandatory);
        this.set(this.graphicData, attributes, 0x700022, DatasetAccessor.Type.Mandatory);
        this.set(this.graphicType, attributes, 7340067, DatasetAccessor.Type.Mandatory);
        this.set(this.graphicFilled, attributes, 7340068, DatasetAccessor.Type.ConditionalMandatory);
        if (this.tianiROIID != null) {
            attributes.setString("TIANI", 0x710010, VR.CS, this.tianiROIID);
        }
        if (this.tianiSubType != null) {
            attributes.setString("TIANI", 7405603, VR.CS, this.tianiSubType.dicom());
        }
        if (this.tianiPositionData != null) {
            attributes.setDouble("TIANI", 7405616, VR.FD, this.tianiPositionData);
        }
        return attributes;
    }

    public static GraphicObject create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x700005) && attributes.contains(7340067) && attributes.contains(0x700022)) {
            return new GraphicObject(attributes);
        }
        return null;
    }

    public static List<GraphicObject> createList(Attributes attributes, int n) {
        ArrayList<GraphicObject> arrayList = new ArrayList<GraphicObject>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            GraphicObject graphicObject = GraphicObject.create((Attributes)sequence.get(n2));
            if (graphicObject != null) {
                arrayList.add(graphicObject);
            }
            ++n2;
        }
        return arrayList;
    }

    public AnnotationUnits getGraphicAnnotationUnits() {
        return this.graphicAnnotationUnits;
    }

    public float[] getGraphicData() {
        return this.graphicData;
    }

    public int getGraphicDimensions() {
        return this.graphicDimensions;
    }

    public YN getGraphicFilled() {
        return this.graphicFilled;
    }

    public GraphicType getGraphicType() {
        return this.graphicType;
    }

    public Integer getNumberOfGraphicPoints() {
        return this.numberOfGraphicPoints;
    }

    public String getTianiID() {
        return this.tianiID;
    }

    public String getTianiROIID() {
        return this.tianiROIID;
    }

    public TianiSubType getTianiSubType() {
        return this.tianiSubType;
    }

    public double[] getTianiPositionData() {
        return this.tianiPositionData;
    }

    public void setGraphicAnnotationUnits(AnnotationUnits annotationUnits) {
        this.graphicAnnotationUnits = annotationUnits;
    }

    public void setGraphicData(float[] fArray) {
        this.graphicData = fArray;
    }

    public void setGraphicDimensions(int n) {
        this.graphicDimensions = n;
    }

    public void setGraphicFilled(YN yN) {
        this.graphicFilled = yN;
    }

    public void setGraphicType(GraphicType graphicType) {
        this.graphicType = graphicType;
    }

    public void setNumberOfGraphicPoints(Integer n) {
        this.numberOfGraphicPoints = n;
    }

    public void setTianiROIID(String string) {
        this.tianiROIID = string;
    }

    public void setTianiSubType(TianiSubType tianiSubType) {
        this.tianiSubType = tianiSubType;
    }

    public void setTianiID(String string) {
        this.tianiID = string;
    }

    public void setTianiPositionData(double d, double d2, double d3, double d4) {
        this.tianiPositionData = new double[]{d, d2, d3, d4};
    }
}

