/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.dicomobject.interfaces.IImageReferencing;
import com.agfa.pacs.listtext.dicomobject.module.ps.GraphicObject;
import com.agfa.pacs.listtext.dicomobject.module.ps.TextObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class GraphicAnnotation
extends AbstractDatasetSource
implements IImageReferencing {
    private List<TextObject> textObjects;
    private List<GraphicObject> graphicObjects;
    private String graphicLayer;
    private Map<String, ReferencedImage> referencedImages;
    private boolean isSaved = false;

    public String getGraphicLayer() {
        return this.graphicLayer;
    }

    public GraphicAnnotation() {
        this.textObjects = new ArrayList<TextObject>();
        this.graphicObjects = new ArrayList<GraphicObject>();
        this.referencedImages = new LinkedHashMap<String, ReferencedImage>();
    }

    private GraphicAnnotation(Attributes attributes) {
        this.referencedImages = ReferencedImage.createMap(attributes, 528704);
        this.graphicLayer = this.getString(attributes, 0x700002);
        this.textObjects = TextObject.createList(attributes, 0x700008);
        this.graphicObjects = GraphicObject.createList(attributes, 0x700009);
    }

    public void setSaved(boolean bl) {
        this.isSaved = bl;
    }

    public boolean isSaved() {
        return this.isSaved;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.referencedImages.values(), attributes, 528704, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.graphicLayer, attributes, 0x700002, DatasetAccessor.Type.Mandatory);
        this.set(this.textObjects, attributes, 0x700008, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.graphicObjects, attributes, 0x700009, DatasetAccessor.Type.ConditionalMandatory);
        return attributes;
    }

    public static GraphicAnnotation create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x700002)) {
            return new GraphicAnnotation(attributes);
        }
        return null;
    }

    public static List<GraphicAnnotation> createList(Attributes attributes, int n) {
        ArrayList<GraphicAnnotation> arrayList = new ArrayList<GraphicAnnotation>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            GraphicAnnotation graphicAnnotation = GraphicAnnotation.create((Attributes)sequence.get(n2));
            if (graphicAnnotation != null) {
                arrayList.add(graphicAnnotation);
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    public Map<String, ReferencedImage> referencedImages() {
        return this.referencedImages;
    }

    public List<TextObject> textObjects() {
        return this.textObjects;
    }

    public List<GraphicObject> graphicObjects() {
        return this.graphicObjects;
    }

    public void setGraphicLayer(String string) {
        this.graphicLayer = string;
    }
}

