/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.ps;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedImage;
import com.agfa.pacs.listtext.dicomobject.interfaces.IImageReferencing;
import com.agfa.pacs.listtext.dicomobject.module.image.ImagePixel;
import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class DisplayedArea
extends AbstractDatasetSource
implements IImageReferencing {
    private static final int[] fixTopRightPoint = new int[]{1, 1};
    private int[] displayedAreaTopLeftHandCorner;
    private int[] displayedAreaBottomRightHandCorner;
    private double[] presentationPixelSpacing;
    private int[] presentationPixelAspectRatio;
    private Float presentationPixelMagnificationRatio;
    private Map<String, ReferencedImage> referencedImages;
    private PresentationSizeMode presentationSizeMode;

    public DisplayedArea(PresentationSizeMode presentationSizeMode, ImagePixel imagePixel) {
        this.displayedAreaBottomRightHandCorner = new int[]{imagePixel.getColumns(), imagePixel.getRows()};
        this.presentationSizeMode = presentationSizeMode;
        this.presentationPixelAspectRatio = imagePixel.getPixelAspectRatio();
    }

    public DisplayedArea() {
        this.referencedImages = new LinkedHashMap<String, ReferencedImage>();
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder("DisplayedArea: TopLeftHandCorner: [" + this.displayedAreaTopLeftHandCorner[0] + ", " + this.displayedAreaTopLeftHandCorner[1] + "], " + "BottomRightHandCorner: [" + this.displayedAreaBottomRightHandCorner[0] + ", " + this.displayedAreaBottomRightHandCorner[1] + "], " + "PresentationPixelSpacing: [");
        if (this.presentationPixelSpacing == null) {
            stringBuilder.append("null");
        } else {
            n = 0;
            while (n < this.presentationPixelSpacing.length) {
                stringBuilder.append(String.valueOf(this.presentationPixelSpacing[n]) + " ");
                ++n;
            }
        }
        stringBuilder.append("], PresentationPixelAspectRatio: [");
        if (this.presentationPixelAspectRatio == null) {
            stringBuilder.append("null");
        } else {
            n = 0;
            while (n < this.presentationPixelAspectRatio.length) {
                stringBuilder.append(String.valueOf(this.presentationPixelAspectRatio[n]) + " ");
                ++n;
            }
        }
        stringBuilder.append("], PresentationPixelMagnificationRatio: " + this.presentationPixelMagnificationRatio + ", PresentationSizeMode: " + (Object)((Object)this.presentationSizeMode));
        return stringBuilder.toString();
    }

    private DisplayedArea(Attributes attributes) {
        this.referencedImages = ReferencedImage.createMap(attributes, 528704);
        this.displayedAreaTopLeftHandCorner = this.getIntegers(attributes, 7340114);
        this.displayedAreaBottomRightHandCorner = this.getIntegers(attributes, 7340115);
        this.presentationSizeMode = PresentationSizeMode.get(this.getString(attributes, 0x700100));
        this.presentationPixelSpacing = this.getDoubles(attributes, 0x700101);
        this.presentationPixelAspectRatio = this.getIntegers(attributes, 7340290);
        this.presentationPixelMagnificationRatio = this.getFloat(attributes, 7340291);
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.referencedImages.values(), attributes, 528704, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.getDisplayedAreaTopLeftHandCorner(), attributes, 7340114, DatasetAccessor.Type.Mandatory);
        this.set(this.displayedAreaBottomRightHandCorner, attributes, 7340115, DatasetAccessor.Type.Mandatory);
        this.set(this.presentationSizeMode, attributes, 0x700100, DatasetAccessor.Type.Mandatory);
        this.set(this.presentationPixelSpacing, attributes, 0x700101, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.presentationPixelAspectRatio, attributes, 7340290, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.presentationPixelMagnificationRatio, attributes, 7340291, DatasetAccessor.Type.ConditionalMandatory);
        return attributes;
    }

    public static DisplayedArea create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(7340114) && attributes.contains(7340115)) {
            return new DisplayedArea(attributes);
        }
        return null;
    }

    public static List<DisplayedArea> createList(Attributes attributes, int n) {
        ArrayList<DisplayedArea> arrayList = new ArrayList<DisplayedArea>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            DisplayedArea displayedArea = DisplayedArea.create((Attributes)sequence.get(n2));
            if (displayedArea != null) {
                arrayList.add(displayedArea);
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    public Map<String, ReferencedImage> referencedImages() {
        return this.referencedImages;
    }

    public int[] getDisplayedAreaBottomRightHandCorner() {
        return this.displayedAreaBottomRightHandCorner;
    }

    public int[] getDisplayedAreaTopLeftHandCorner() {
        if (this.displayedAreaTopLeftHandCorner == null) {
            return fixTopRightPoint;
        }
        return this.displayedAreaTopLeftHandCorner;
    }

    public int[] getPresentationPixelAspectRatio() {
        return this.presentationPixelAspectRatio;
    }

    public Float getPresentationPixelMagnificationRatio() {
        return this.presentationPixelMagnificationRatio;
    }

    public double[] getPresentationPixelSpacing() {
        return this.presentationPixelSpacing;
    }

    public PresentationSizeMode getPresentationSizeMode() {
        return this.presentationSizeMode;
    }

    public void setPresentationSizeMode(PresentationSizeMode presentationSizeMode) {
        this.presentationSizeMode = presentationSizeMode;
    }

    public void setDisplayedAreaBottomRightHandCorner(int[] nArray) {
        this.displayedAreaBottomRightHandCorner = nArray;
    }

    public void setDisplayedAreaTopLeftHandCorner(int[] nArray) {
        this.displayedAreaTopLeftHandCorner = nArray;
    }

    public void setPresentationPixelAspectRatio(int[] nArray) {
        this.presentationPixelAspectRatio = nArray;
    }

    public void setPresentationPixelMagnificationRatio(Float f) {
        this.presentationPixelMagnificationRatio = f;
    }

    public void setPresentationPixelSpacing(double[] dArray) {
        this.presentationPixelSpacing = dArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DisplayedArea)) {
            return false;
        }
        DisplayedArea displayedArea = (DisplayedArea)object;
        if (!this.match(this.displayedAreaBottomRightHandCorner, displayedArea.displayedAreaBottomRightHandCorner)) {
            return false;
        }
        if (!this.match(this.displayedAreaTopLeftHandCorner, displayedArea.displayedAreaTopLeftHandCorner)) {
            return false;
        }
        if (!this.match(this.presentationPixelAspectRatio, displayedArea.presentationPixelAspectRatio)) {
            return false;
        }
        if (!this.match(this.presentationPixelMagnificationRatio, displayedArea.presentationPixelMagnificationRatio)) {
            return false;
        }
        if (!this.match(this.presentationPixelSpacing, displayedArea.presentationPixelSpacing)) {
            return false;
        }
        return this.presentationSizeMode == displayedArea.presentationSizeMode;
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

