/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.patient;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.dicom.YesNo;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.interfaces.IExtendedPatientIdentifier;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class PatientModule
extends AbstractModule
implements IExtendedPatientIdentifier {
    private String patientName;
    private String patientID;
    private String issuerOfPatientID;
    private Date patientBirthDate;
    private String patientSex;
    private ReferencedSOP referencedPatient;
    private Date patientBirthTime;
    private String[] otherPatientIDs;
    private String[] otherPatientNames;
    private String patientComments;
    private YesNo patientIdentityRemoved;
    private String deidentificationMethod;
    private List<Code> deidentificationMethodCodes;
    private String ethnicGroup;

    public PatientModule() {
        super(Level.Patient);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.patientName = this.getString(attributes, 0x100010);
        this.patientID = this.getString(attributes, 0x100020);
        this.issuerOfPatientID = this.getString(attributes, 0x100021);
        this.patientBirthDate = this.getDate(attributes, 0x100030);
        this.patientSex = this.getString(attributes, 0x100040);
        this.referencedPatient = ReferencedSOP.create(attributes.getNestedDataset(528672));
        this.patientBirthTime = this.getDate(attributes, 1048626);
        this.otherPatientIDs = this.getStrings(attributes, 0x101000);
        this.otherPatientNames = this.getStrings(attributes, 0x101001);
        this.patientComments = this.getString(attributes, 0x104000);
        this.patientIdentityRemoved = YesNo.get((String)this.getString(attributes, 1179746));
        this.deidentificationMethod = this.getString(attributes, 1179747);
        this.deidentificationMethodCodes = Code.createList((Attributes)attributes, (int)1179748);
        this.ethnicGroup = this.getString(attributes, 1057120);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.patientName, attributes, 0x100010, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.patientID, attributes, 0x100020, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.issuerOfPatientID, attributes, 0x100021, DatasetAccessor.Type.Optional);
        this.set(this.patientBirthDate, attributes, 0x100030, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.patientSex, attributes, 0x100040, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set((DatasetSource)this.referencedPatient, attributes, 528672, DatasetAccessor.Type.Optional);
        this.set(this.patientBirthTime, attributes, 1048626, DatasetAccessor.Type.Optional);
        this.set(this.otherPatientIDs, attributes, 0x101000, DatasetAccessor.Type.Optional);
        this.set(this.otherPatientNames, attributes, 0x101001, DatasetAccessor.Type.Optional);
        this.set(this.patientComments, attributes, 0x104000, DatasetAccessor.Type.Optional);
        this.set(this.ethnicGroup, attributes, 1057120, DatasetAccessor.Type.Optional);
        this.set((DicomEnum)this.patientIdentityRemoved, attributes, 1179746, DatasetAccessor.Type.Optional);
        this.set(this.deidentificationMethod, attributes, 1179747, DatasetAccessor.Type.ConditionalMandatory);
        this.set(this.deidentificationMethodCodes, attributes, 1179748, DatasetAccessor.Type.ConditionalMandatory);
    }

    @Override
    public String getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    @Override
    public Date getPatientBirthDate() {
        return this.patientBirthDate;
    }

    @Override
    public String getPatientID() {
        return this.patientID;
    }

    @Override
    public String getPatientName() {
        return this.patientName;
    }

    @Override
    public String getPatientSex() {
        return this.patientSex;
    }

    @Override
    public String[] getOtherPatientIDs() {
        return this.otherPatientIDs;
    }

    @Override
    public String[] getOtherPatientNames() {
        return this.otherPatientNames;
    }

    public Date getPatientBirthTime() {
        return this.patientBirthTime;
    }

    public String getPatientComments() {
        return this.patientComments;
    }

    public ReferencedSOP getReferencedPatient() {
        return this.referencedPatient;
    }

    public String getDeidentificationMethod() {
        return this.deidentificationMethod;
    }

    public void setDeidentificationMethod(String string) {
        this.deidentificationMethod = string;
    }

    public YesNo getPatientIdentityRemoved() {
        return this.patientIdentityRemoved;
    }

    public void setPatientIdentityRemoved(YesNo yesNo) {
        this.patientIdentityRemoved = yesNo;
    }

    public List<Code> deidentificationMethodCodes() {
        return this.deidentificationMethodCodes;
    }

    @Override
    public void setIssuerOfPatientID(String string) {
        this.issuerOfPatientID = string;
    }

    public void setOtherPatientIds(String[] stringArray) {
        this.otherPatientIDs = stringArray;
    }

    public void setOtherPatientNames(String[] stringArray) {
        this.otherPatientNames = stringArray;
    }

    @Override
    public void setPatientBirthDate(Date date) {
        this.patientBirthDate = date;
    }

    public void setPatientBirthTime(Date date) {
        this.patientBirthTime = date;
    }

    public void setPatientComments(String string) {
        this.patientComments = string;
    }

    @Override
    public void setPatientID(String string) {
        this.patientID = string;
    }

    @Override
    public void setPatientName(String string) {
        this.patientName = string;
    }

    @Override
    public void setPatientSex(String string) {
        this.patientSex = string;
    }

    public void setReferencedPatient(ReferencedSOP referencedSOP) {
        this.referencedPatient = referencedSOP;
    }

    public String getEthnicGroup() {
        return this.ethnicGroup;
    }

    public void setEthnicGroup(String string) {
        this.ethnicGroup = string;
    }
}

