/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.mwl;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.interfaces.IPatientIdentifier;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import com.agfa.pacs.listtext.dicomobject.module.mwl.ScheduledStepAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class PerformedProcedureStepRelationshipModule
extends AbstractModule
implements IPatientIdentifier {
    private String patientID;
    private Date patientBirthDate;
    private String patientSex;
    private String patientName;
    private String issuerOfPatientID;
    private ReferencedSOP referencedPatient;
    private List<ScheduledStepAttribute> scheduledStepAttributes = new ArrayList<ScheduledStepAttribute>();
    private String admissionID;
    private String issuerOfAdmissionID;

    public PerformedProcedureStepRelationshipModule() {
        super(null);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.patientName = this.getString(attributes, 0x100010);
        this.patientID = this.getString(attributes, 0x100020);
        this.issuerOfPatientID = this.getString(attributes, 0x100021);
        this.patientBirthDate = this.getDate(attributes, 0x100030);
        this.patientSex = this.getString(attributes, 0x100040);
        this.referencedPatient = ReferencedSOP.create(attributes.getNestedDataset(528672));
        this.scheduledStepAttributes = ScheduledStepAttribute.createList(attributes, 4194928);
        this.admissionID = this.getString(attributes, 3670032);
        this.issuerOfAdmissionID = this.getString(attributes, 3670033);
    }

    public void readFrom(IPatientIdentifier iPatientIdentifier) {
        this.patientName = iPatientIdentifier.getPatientName();
        this.patientID = iPatientIdentifier.getPatientID();
        this.issuerOfPatientID = iPatientIdentifier.getIssuerOfPatientID();
        this.patientBirthDate = iPatientIdentifier.getPatientBirthDate();
        this.patientSex = iPatientIdentifier.getPatientSex();
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.patientName, attributes, 0x100010, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.patientID, attributes, 0x100020, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.issuerOfPatientID, attributes, 0x100021, DatasetAccessor.Type.Optional);
        this.set(this.patientBirthDate, attributes, 0x100030, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.patientSex, attributes, 0x100040, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set((DatasetSource)this.referencedPatient, attributes, 528672, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.scheduledStepAttributes, attributes, 4194928, DatasetAccessor.Type.Optional);
    }

    public void writeToNCreate(Attributes attributes) {
        this.set(this.patientName, attributes, 0x100010, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.patientID, attributes, 0x100020, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.issuerOfPatientID, attributes, 0x100021, DatasetAccessor.Type.Optional);
        this.set(this.patientBirthDate, attributes, 0x100030, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.patientSex, attributes, 0x100040, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set((DatasetSource)this.referencedPatient, attributes, 528672, DatasetAccessor.Type.MandatoryOrEmpty);
        this.set(this.scheduledStepAttributes, attributes, 4194928, DatasetAccessor.Type.Mandatory);
        this.set(this.admissionID, attributes, 3670032, DatasetAccessor.Type.Optional);
        this.set(this.issuerOfAdmissionID, attributes, 3670033, DatasetAccessor.Type.Optional);
    }

    @Override
    public String getPatientName() {
        return this.patientName;
    }

    @Override
    public String getPatientID() {
        return this.patientID;
    }

    @Override
    public String getIssuerOfPatientID() {
        return this.issuerOfPatientID;
    }

    @Override
    public Date getPatientBirthDate() {
        return this.patientBirthDate;
    }

    @Override
    public String getPatientSex() {
        return this.patientSex;
    }

    public ReferencedSOP getReferencedPatient() {
        return this.referencedPatient;
    }

    public List<ScheduledStepAttribute> scheduledStepAttributes() {
        return this.scheduledStepAttributes;
    }

    public String getAdmissionID() {
        return this.admissionID;
    }

    public String getIssuerOfAdmissionID() {
        return this.issuerOfAdmissionID;
    }

    public void setAdmissionID(String string) {
        this.admissionID = string;
    }

    public void setIssuerOfAdmissionID(String string) {
        this.issuerOfAdmissionID = string;
    }

    @Override
    public void setIssuerOfPatientID(String string) {
        this.issuerOfPatientID = string;
    }

    @Override
    public void setPatientBirthDate(Date date) {
        this.patientBirthDate = date;
    }

    @Override
    public void setPatientID(String string) {
        this.patientID = string;
    }

    @Override
    public void setPatientName(String string) {
        this.patientName = string;
    }

    @Override
    public void setPatientSex(String string) {
        this.patientSex = string;
    }

    public void setReferencedPatient(ReferencedSOP referencedSOP) {
        this.referencedPatient = referencedSOP;
    }
}

