/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.module.general;

import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.interfaces.IInstanceIdentifier;
import com.agfa.pacs.listtext.dicomobject.module.AbstractModule;
import java.util.Date;
import org.dcm4che3.data.Attributes;

public class SOPCommonModule
extends AbstractModule
implements IInstanceIdentifier {
    private String sopClassUID;
    private String specificCharacterSet;
    private String sopInstanceUID;
    private Date instanceCreationDate;
    private Date instanceCreationTime;
    private Integer instanceNumber;
    private String instanceCreatorUID;

    public SOPCommonModule() {
        super(Level.Object);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean containsModule(Attributes attributes) {
        return true;
    }

    @Override
    public void readFrom(Attributes attributes) {
        this.sopClassUID = this.getString(attributes, 524310);
        this.sopInstanceUID = this.getString(attributes, 524312);
        this.specificCharacterSet = this.getString(attributes, 524293);
        this.instanceCreationDate = this.getDate(attributes, 524306);
        this.instanceCreationTime = this.getDate(attributes, 524307);
        this.instanceCreatorUID = this.getString(attributes, 524308);
        this.instanceNumber = this.getInteger(attributes, 2097171);
    }

    @Override
    public void writeTo(Attributes attributes) {
        this.set(this.sopClassUID, attributes, 524310, DatasetAccessor.Type.Mandatory);
        this.set(this.sopInstanceUID, attributes, 524312, DatasetAccessor.Type.Mandatory);
        this.set(this.specificCharacterSet, attributes, 524293, DatasetAccessor.Type.Mandatory);
        this.set(this.instanceCreationDate, attributes, 524306, DatasetAccessor.Type.Optional);
        this.set(this.instanceCreationTime, attributes, 524307, DatasetAccessor.Type.Optional);
        this.set(this.instanceCreatorUID, attributes, 524308, DatasetAccessor.Type.Optional);
        this.set(this.instanceNumber, attributes, 2097171, DatasetAccessor.Type.Mandatory);
    }

    public ReferencedSOP createReferencedSOP() {
        return new ReferencedSOP(this.sopClassUID, this.sopInstanceUID);
    }

    public String getSOPClassUID() {
        return this.sopClassUID;
    }

    @Override
    public String getSOPInstanceUID() {
        return this.sopInstanceUID;
    }

    public String getSpecificCharacterSet() {
        return this.specificCharacterSet;
    }

    public void setSOPClassUID(String string) {
        this.sopClassUID = string;
    }

    @Override
    public void setSOPInstanceUID(String string) {
        this.sopInstanceUID = string;
    }

    public void setSpecificCharacterSet(String string) {
        this.specificCharacterSet = string;
    }

    public Date getInstanceCreationDate() {
        return this.instanceCreationDate;
    }

    public Date getInstanceCreationTime() {
        return this.instanceCreationTime;
    }

    @Override
    public Integer getInstanceNumber() {
        return this.instanceNumber;
    }

    @Override
    public void setInstanceNumber(Integer n) {
        this.instanceNumber = n;
    }

    public void setInstanceCreationDate(Date date) {
        this.instanceCreationDate = date;
    }

    public void setInstanceCreationTime(Date date) {
        this.instanceCreationTime = date;
    }

    public String getInstanceCreatorUID() {
        return this.instanceCreatorUID;
    }

    public void setInstanceCreatorUID(String string) {
        this.instanceCreatorUID = string;
    }
}

