/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.general;

import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSeries;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class SOPInstanceReference
extends AbstractDatasetSource {
    private String studyInstanceUID;
    private List<ReferencedSeries> referencedSeries;

    public SOPInstanceReference(String string) {
        this.referencedSeries = new ArrayList<ReferencedSeries>();
        this.studyInstanceUID = string;
    }

    public SOPInstanceReference(String string, String string2, String string3, String string4) {
        this(string);
        this.referencedSeries.add(new ReferencedSeries(string2, string3, string4));
    }

    private SOPInstanceReference(Attributes attributes) {
        this.studyInstanceUID = this.getString(attributes, 0x20000D);
        this.referencedSeries = ReferencedSeries.createList(attributes, 528661);
    }

    public static SOPInstanceReference create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x20000D) && attributes.contains(528661)) {
            return new SOPInstanceReference(attributes);
        }
        return null;
    }

    public static List<SOPInstanceReference> createList(Attributes attributes, int n) {
        ArrayList<SOPInstanceReference> arrayList = new ArrayList<SOPInstanceReference>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence == null) {
            return arrayList;
        }
        int n2 = 0;
        while (n2 < sequence.size()) {
            SOPInstanceReference sOPInstanceReference = SOPInstanceReference.create((Attributes)sequence.get(n2));
            if (sOPInstanceReference != null) {
                arrayList.add(sOPInstanceReference);
            }
            ++n2;
        }
        return arrayList;
    }

    public String getStudyInstanceUID() {
        return this.studyInstanceUID;
    }

    public List<ReferencedSeries> referencedSeries() {
        return this.referencedSeries;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set(this.studyInstanceUID, attributes, 0x20000D, DatasetAccessor.Type.Mandatory);
        this.set(this.referencedSeries, attributes, 528661, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public void addReferencedSeries(ReferencedSeries referencedSeries) {
        this.referencedSeries.add(referencedSeries);
        referencedSeries.setStudyRef(this);
    }
}

