/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.general;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.data.AbstractDatasetSource;
import com.agfa.pacs.data.shared.data.DatasetAccessor;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.listtext.dicomobject.type.ValueType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public abstract class ContentItem
extends AbstractDatasetSource {
    private Code conceptName;
    private ValueType valueType;

    private ContentItem(ValueType valueType) {
        this.valueType = valueType;
    }

    private ContentItem(Attributes attributes) {
        this.conceptName = Code.create((Attributes)attributes, (int)4235331);
        this.valueType = ValueType.get(this.getString(attributes, 0x40A040));
    }

    public static ContentItem create(Attributes attributes) {
        if (attributes == null) {
            return null;
        }
        if (attributes.contains(0x40A040)) {
            String string = attributes.getString(0x40A040, null);
            if ("TEXT".equals(string)) {
                return new TextItem(attributes);
            }
            if ("NUM".equals(string)) {
                return new NumericItem(attributes);
            }
            if ("CODE".equals(string)) {
                return new CodeItem(attributes);
            }
            if ("DATETIME".equals(string)) {
                return new DateTimeItem(attributes);
            }
            if ("DATE".equals(string)) {
                return new DateItem(attributes);
            }
            if ("TIME".equals(string)) {
                return new TimeItem(attributes);
            }
            if ("UIDREF".equals(string)) {
                return new UIDReferenceItem(attributes);
            }
            if ("PNAME".equals(string)) {
                return new PersonNameItem(attributes);
            }
        }
        return null;
    }

    public static ContentItem create(ValueType valueType) {
        switch (valueType) {
            case Text: {
                return new TextItem();
            }
            case Numeric: {
                return new NumericItem();
            }
            case Code: {
                return new CodeItem();
            }
            case DateTime: {
                return new DateTimeItem();
            }
            case Date: {
                return new DateItem();
            }
            case Time: {
                return new TimeItem();
            }
            case UIDReference: {
                return new UIDReferenceItem();
            }
            case PersonName: {
                return new PersonNameItem();
            }
        }
        return null;
    }

    public static List<ContentItem> createList(Attributes attributes, int n) {
        ArrayList<ContentItem> arrayList = new ArrayList<ContentItem>();
        Sequence sequence = attributes.getSequence(n);
        if (sequence != null) {
            int n2 = 0;
            while (n2 < sequence.size()) {
                ContentItem contentItem = ContentItem.create((Attributes)sequence.get(n2));
                if (contentItem != null) {
                    arrayList.add(contentItem);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public ValueType getValueType() {
        return this.valueType;
    }

    public Code getConceptName() {
        return this.conceptName;
    }

    public void setConceptName(Code code) {
        this.conceptName = code;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes();
        this.set((DatasetSource)this.conceptName, attributes, 4235331, DatasetAccessor.Type.Mandatory);
        this.set(this.valueType, attributes, 0x40A040, DatasetAccessor.Type.Mandatory);
        return attributes;
    }

    public String toString() {
        if (this.conceptName == null) {
            return this.valueType.toString();
        }
        return String.valueOf(this.conceptName.toString()) + " (" + this.valueType.toString() + ")";
    }

    /* synthetic */ ContentItem(ValueType valueType, ContentItem contentItem) {
        this(valueType);
    }

    /* synthetic */ ContentItem(Attributes attributes, ContentItem contentItem) {
        this(attributes);
    }

    public static class CodeItem
    extends ContentItem {
        private Code concept;

        public CodeItem() {
            super(ValueType.Code, null);
        }

        public CodeItem(Attributes attributes) {
            super(attributes, null);
            this.concept = Code.create((Attributes)attributes, (int)4235624);
        }

        public Code getConcept() {
            return this.concept;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set((DatasetSource)this.concept, attributes, 4235624, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class DateItem
    extends ContentItem {
        private Date date;

        public DateItem() {
            super(ValueType.Date, null);
        }

        public DateItem(Attributes attributes) {
            super(attributes, null);
            this.date = this.getDate(attributes, 4235553);
        }

        public Date getDate() {
            return this.date;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.date, attributes, 4235553, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class DateTimeItem
    extends ContentItem {
        private Date dateTime;

        public DateTimeItem() {
            super(ValueType.DateTime, null);
        }

        public DateTimeItem(Attributes attributes) {
            super(attributes, null);
            this.dateTime = this.getDate(attributes, 4235552);
        }

        public Date getDateTime() {
            return this.dateTime;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.dateTime, attributes, 4235552, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class NumericItem
    extends ContentItem {
        private Code measurementUnits;
        private String numericValue;

        public NumericItem() {
            super(ValueType.Numeric, null);
        }

        public NumericItem(Attributes attributes) {
            super(attributes, null);
            this.numericValue = this.getString(attributes, 4236042);
            this.measurementUnits = Code.create((Attributes)attributes, (int)4196586);
        }

        public Code getMeasurementUnits() {
            return this.measurementUnits;
        }

        public String getNumericValue() {
            return this.numericValue;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.numericValue, attributes, 4236042, DatasetAccessor.Type.Mandatory);
            this.set((DatasetSource)this.measurementUnits, attributes, 4196586, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class PersonNameItem
    extends ContentItem {
        private String personName;

        public PersonNameItem() {
            super(ValueType.PersonName, null);
        }

        public PersonNameItem(Attributes attributes) {
            super(attributes, null);
            this.personName = this.getString(attributes, 4235555);
        }

        public String getPersonName() {
            return this.personName;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.personName, attributes, 4235555, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class TextItem
    extends ContentItem {
        private String textValue;

        public TextItem() {
            super(ValueType.Text, null);
        }

        public TextItem(Attributes attributes) {
            super(attributes, null);
            this.textValue = this.getString(attributes, 4235616);
        }

        public String getText() {
            return this.textValue;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.textValue, attributes, 4235616, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class TimeItem
    extends ContentItem {
        private Date time;

        public TimeItem() {
            super(ValueType.Time, null);
        }

        public TimeItem(Attributes attributes) {
            super(attributes, null);
            this.time = this.getDate(attributes, 4235554);
        }

        public Date getTime() {
            return this.time;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.time, attributes, 4235554, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }

    public static class UIDReferenceItem
    extends ContentItem {
        private String uid;

        public UIDReferenceItem() {
            super(ValueType.UIDReference, null);
        }

        public UIDReferenceItem(Attributes attributes) {
            super(attributes, null);
            this.uid = this.getString(attributes, 4235556);
        }

        public String getUID() {
            return this.uid;
        }

        @Override
        public Attributes toDataset() {
            Attributes attributes = super.toDataset();
            this.set(this.uid, attributes, 4235556, DatasetAccessor.Type.Mandatory);
            return attributes;
        }
    }
}

