/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.logging.ALogger;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class URLEncodeUtil {
    public static final String DEFAULT_CHARACTER_ENCODING;
    private static final ALogger LOGGER;
    private static final String FALLBACK_CHARACTER_ENCODING = "ISO-8859-1";
    private static final String SYSTEM_PROPERTY_KEY = "server.encoding";

    static {
        LOGGER = ALogger.getLogger(URLEncodeUtil.class);
        String string = System.getProperty(SYSTEM_PROPERTY_KEY);
        if (string == null) {
            string = FALLBACK_CHARACTER_ENCODING;
        }
        DEFAULT_CHARACTER_ENCODING = string;
        LOGGER.debug("Using the following character encoding for URL encoding: " + string);
    }

    private URLEncodeUtil() {
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        try {
            return URLEncoder.encode(string, DEFAULT_CHARACTER_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOGGER.warn("Encoding failed: " + string, (Throwable)unsupportedEncodingException);
            return string;
        }
    }
}

