/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.core.ApplicationManagement;
import com.agfa.pacs.tools.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public class TempDirectoryProvider {
    private static final boolean IS_AGILITY = ApplicationManagement.getInstance().getApplicationType().isAgility();
    private static final String JAVA_TEMP_IO = "java.io.tmpdir";
    public static final String AGILITY_CACHE_DIR_INFIX = "AgilityCache" + File.separator + TempDirectoryProvider.getDesktopType();
    private static Path temporaryDirectory;

    static {
        try {
            temporaryDirectory = Files.createTempDirectory("AgilityTemp", new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                FileUtil.remove(temporaryDirectory.toFile());
            }
        }));
    }

    public static Path createTempDirectory(String string) throws IOException {
        return Files.createTempDirectory(temporaryDirectory, string, new FileAttribute[0]);
    }

    public static Path getCacheDirectory(String string) {
        Path path = Paths.get(System.getProperty(JAVA_TEMP_IO), AGILITY_CACHE_DIR_INFIX);
        Path path2 = path.resolve(string).normalize();
        try {
            Files.createDirectories(path2, new FileAttribute[0]);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return path2;
    }

    public static String getDesktopType() {
        return System.getProperty("form", "diagnostic.desktop");
    }
}

