/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.tools;

import com.agfa.pacs.logging.ALogger;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URI;

public class OpenLink {
    public static boolean openLink(String string) {
        if (Desktop.isDesktopSupported()) {
            try {
                URI uRI = null;
                uRI = string.contains("://") ? new URI(string) : new File(string).toURI();
                Desktop.getDesktop().browse(uRI);
                return true;
            }
            catch (Exception exception) {
                ALogger.getLogger((String)"OpenLink").warn("Could not open link:" + string, (Throwable)exception);
                return false;
            }
        }
        try {
            File file = File.createTempFile("link", ".url");
            PrintStream printStream = new PrintStream(file);
            printStream.println("[InternetShortcut]");
            printStream.println("URL=" + string);
            printStream.close();
            file.deleteOnExit();
            Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "\"" + file.getAbsolutePath() + "\""});
            return true;
        }
        catch (Exception exception) {
            ALogger.getLogger((String)"OpenLink").warn("Could not open link:" + string, (Throwable)exception);
            return false;
        }
    }

    public static void openFile(File file) throws UnsupportedOperationException {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (IOException iOException) {
                throw new UnsupportedOperationException("Start of external app failed", iOException);
            }
        }
        try {
            Runtime.getRuntime().exec(new String[]{"cmd.exe", "/c", "\"" + file.getAbsolutePath() + "\""});
        }
        catch (IOException iOException) {
            throw new UnsupportedOperationException("Start of external app failed", iOException);
        }
    }

    public static boolean printFile(File file) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().print(file);
                return true;
            }
            catch (IOException iOException) {
                ALogger.getLogger((String)"OpenLink").warn("Printing file failed: " + file.getAbsolutePath(), (Throwable)iOException);
            }
        }
        return false;
    }
}

