/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.services;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.services.IImageAreaStatusProvider;
import com.agfa.pacs.services.ImageAreaStatusServiceProviderFactory;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class ImageAreaStatusServiceProviderFactoryEclipseImpl
extends ImageAreaStatusServiceProviderFactory {
    private static final String EXT_POINT_STATUS_PROVIDER_CLASS_ATTRIBUTE_NAME = "class";
    private static final ALogger LOGGER = ALogger.getLogger(ImageAreaStatusServiceProviderFactoryEclipseImpl.class);
    private final List<IImageAreaStatusProvider> statusProviders = new LinkedList<IImageAreaStatusProvider>();

    public ImageAreaStatusServiceProviderFactoryEclipseImpl() {
        try {
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.core.shared.ImageAreaStatusProvider");
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension iExtension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n4];
                    ImageAreaStatusProviderProxy imageAreaStatusProviderProxy = new ImageAreaStatusProviderProxy(iConfigurationElement);
                    this.statusProviders.add(imageAreaStatusProviderProxy);
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            LOGGER.error("Error while parsing implementations of status provider extension point com.agfa.pacs.core.shared.ImageAreaStatusProvider", (Throwable)exception);
        }
    }

    @Override
    public List<IImageAreaStatusProvider> getAllStatusProvider() {
        return this.statusProviders;
    }

    private static final class ImageAreaStatusProviderProxy
    implements IImageAreaStatusProvider {
        private final IConfigurationElement ce;
        private IImageAreaStatusProvider delegate = null;
        private boolean delegateInitFailed = false;

        private ImageAreaStatusProviderProxy(IConfigurationElement iConfigurationElement) {
            this.ce = iConfigurationElement;
        }

        @Override
        public boolean exportStatus(OutputStream outputStream) {
            if (this.delegate == null) {
                if (this.delegateInitFailed) {
                    return false;
                }
                this.initializeDelegate();
            }
            return this.delegate.exportStatus(outputStream);
        }

        @Override
        public String getStatusType() {
            if (this.delegate == null) {
                if (this.delegateInitFailed) {
                    return null;
                }
                this.initializeDelegate();
            }
            return this.delegate.getStatusType();
        }

        @Override
        public String getPreferredExportFilename() {
            if (this.delegate == null) {
                if (this.delegateInitFailed) {
                    return null;
                }
                this.initializeDelegate();
            }
            return this.delegate.getPreferredExportFilename();
        }

        private void initializeDelegate() {
            try {
                this.delegate = (IImageAreaStatusProvider)this.ce.createExecutableExtension(ImageAreaStatusServiceProviderFactoryEclipseImpl.EXT_POINT_STATUS_PROVIDER_CLASS_ATTRIBUTE_NAME);
            }
            catch (CoreException coreException) {
                LOGGER.error("Failed to initialize IImageAreaStatusProvider", (Throwable)coreException);
                this.delegateInitFailed = true;
            }
        }
    }
}

