/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.messages;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.messages.UnicodeResourceClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class SharedMessages {
    private static final String BUNDLE_NAME = "shared.messages";
    protected static final String DEFAULT_BUNDLE_NAME = "messages";
    protected static final ALogger log = ALogger.getLogger(SharedMessages.class);
    private static final boolean useMinicoreLocalization = ConfigurationProviderFactory.getBaseConfig().getBoolean("com.agfa.pacs.messages.useMinicoreLocalization");
    private static final ResourceBundle RESOURCE_BUNDLE = !useMinicoreLocalization ? ResourceBundle.getBundle("shared.messages", Locale.getDefault(), new UnicodeResourceClassLoader(SharedMessages.class.getClassLoader())) : ResourceBundle.getBundle("com.agfa.pacs.minicore.messages", Locale.getDefault(), new UnicodeResourceClassLoader(SharedMessages.class.getClassLoader()));

    public static ResourceBundle getBundle(String string, Locale locale, Class<?> clazz) {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string, locale, new UnicodeResourceClassLoader(clazz.getClassLoader()));
            return resourceBundle;
        }
        catch (Exception exception) {
            if (!useMinicoreLocalization) {
                log.error("Resource bundle for package '" + clazz.getPackage().toString() + "' not found", (Throwable)exception);
            }
            return null;
        }
    }

    public static ResourceBundle getBundle(String string, Class<?> clazz) {
        return SharedMessages.getBundle(string, Locale.getDefault(), clazz);
    }

    public static ResourceBundle getBundle(Class<?> clazz) {
        return SharedMessages.getBundle(DEFAULT_BUNDLE_NAME, Locale.getDefault(), clazz);
    }

    private static String getString(String string) {
        try {
            return RESOURCE_BUNDLE.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String getString(ResourceBundle resourceBundle, String string) {
        String string2 = null;
        if (resourceBundle != null) {
            try {
                string2 = resourceBundle.getString(string);
                return string2;
            }
            catch (MissingResourceException missingResourceException) {}
        }
        if ((string2 = SharedMessages.getString(string)) == null) {
            if (!useMinicoreLocalization) {
                log.warn("Missing key '" + string + "'");
                return String.valueOf('!') + string + '!';
            }
            return "(!)" + string + "(/!)";
        }
        return string2;
    }

    public static String getStringNoLog(ResourceBundle resourceBundle, String string) {
        if (resourceBundle == null) {
            return string;
        }
        String string2 = null;
        try {
            string2 = resourceBundle.getString(string);
            return string2;
        }
        catch (MissingResourceException missingResourceException) {
            string2 = SharedMessages.getString(string);
            if (string2 == null) {
                return string;
            }
            return string2;
        }
    }
}

