/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.login;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.IURLProvider;
import com.agfa.pacs.login.URLProviderFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.RegistryFactory;

public class URLProviderFactoryEclipseImpl
extends URLProviderFactory {
    private static final ALogger LOGGER = ALogger.getLogger(URLProviderFactoryEclipseImpl.class);
    private IURLProvider urlProvider;

    public URLProviderFactoryEclipseImpl() {
        IExtensionPoint iExtensionPoint = RegistryFactory.getRegistry().getExtensionPoint("com.agfa.pacs.core.shared.UrlProvider");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        if (iExtensionArray == null || iExtensionArray.length == 0) {
            throw new IllegalStateException("no Url provider implementation found");
        }
        try {
            TreeSet<IConfigurationElement> treeSet = new TreeSet<IConfigurationElement>(new ConfigurationElementComparator());
            IExtension[] iExtensionArray2 = iExtensionArray;
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension iExtension = iExtensionArray2[n2];
                treeSet.addAll(Arrays.asList(iExtension.getConfigurationElements()));
                ++n2;
            }
            this.urlProvider = (IURLProvider)((IConfigurationElement)treeSet.iterator().next()).createExecutableExtension("class");
        }
        catch (CoreException coreException) {
            LOGGER.error("Cannot create instance of URL Provider!", (Throwable)coreException);
        }
    }

    @Override
    protected IURLProvider getProviderInt() {
        return this.urlProvider;
    }

    private static class ConfigurationElementComparator
    implements Comparator<IConfigurationElement>,
    Serializable {
        private static final long serialVersionUID = -8817150858231556009L;

        private ConfigurationElementComparator() {
        }

        @Override
        public int compare(IConfigurationElement iConfigurationElement, IConfigurationElement iConfigurationElement2) {
            Integer n;
            Integer n2 = iConfigurationElement == null ? null : ConfigurationElementComparator.getConfigurationElementPriority(iConfigurationElement);
            Integer n3 = n = iConfigurationElement2 == null ? null : ConfigurationElementComparator.getConfigurationElementPriority(iConfigurationElement2);
            if (n2 != null || n != null) {
                if (n2 == null) {
                    return -1;
                }
                if (n == null) {
                    return 1;
                }
                int n4 = n.compareTo(n2);
                return n4 == 0 ? 1 : n4;
            }
            return 1;
        }

        private static Integer getConfigurationElementPriority(IConfigurationElement iConfigurationElement) {
            try {
                return Integer.valueOf(iConfigurationElement.getAttribute("priority"));
            }
            catch (Exception exception) {
                return Integer.MIN_VALUE;
            }
        }
    }
}

