/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.keyobject;

import com.agfa.pacs.keyobject.KeyObjectTitleComparator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class KeyObjectTitle {
    private final int order;
    private final String schemeDesignator;
    private final String code;
    private final String meaning;
    private final String localizedMeaning;
    private final boolean ofTypeRejected;
    private Map<String, KeyObjectTitle> codeToSubTitle;
    private Set<KeyObjectTitle> sortedSubTitles;

    public KeyObjectTitle(int n, String string, String string2, String string3, String string4, boolean bl) {
        this.order = n;
        this.schemeDesignator = string;
        this.code = string2;
        this.meaning = string3;
        this.localizedMeaning = string4;
        this.ofTypeRejected = bl;
    }

    public void addSubTitle(KeyObjectTitle keyObjectTitle) {
        if (this.codeToSubTitle == null) {
            this.codeToSubTitle = new HashMap<String, KeyObjectTitle>();
        }
        if (this.sortedSubTitles == null) {
            this.sortedSubTitles = new TreeSet<KeyObjectTitle>(new KeyObjectTitleComparator());
        }
        this.codeToSubTitle.put(keyObjectTitle.getCode(), keyObjectTitle);
        this.sortedSubTitles.add(keyObjectTitle);
    }

    public Set<KeyObjectTitle> getSubTitles() {
        if (this.sortedSubTitles == null) {
            this.sortedSubTitles = Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.sortedSubTitles);
    }

    public KeyObjectTitle getSubTitle(String string) {
        return this.codeToSubTitle.get(string);
    }

    public int getOrder() {
        return this.order;
    }

    public String getSchemeDesignator() {
        return this.schemeDesignator;
    }

    public String getCode() {
        return this.code;
    }

    public String getMeaning() {
        return this.meaning;
    }

    public String getLocalizedMeaning() {
        return this.localizedMeaning;
    }

    public boolean isOfTypeRejected() {
        return this.ofTypeRejected;
    }
}

