/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.cache;

import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.ICacheItemGroup;
import java.io.File;
import java.util.Iterator;

public interface IDataCacheProvider {
    public static final String DATA_CACHE_EXT_PT = "com.agfa.pacs.core.shared.DataCacheProvider";
    public static final int PERSISTENCE_ETHERNAL = 2;
    public static final int PERSISTENCE_PERMANENT = 1;
    public static final int PERSISTENCE_TEMPORARY = 0;
    public static final int MAX_ITEM_PRIORITY = 30;
    public static final int DEFAULT_ITEM_PRIORITY = 30;
    public static final String[] persistenceModifiers = new String[]{"temp", "perm", "ethe"};

    public CacheID createID();

    public CacheID createID(String var1, String var2, int var3);

    public ICacheItemGroup getItemGroup(String var1);

    public byte[] allocBytes(long var1);

    public byte[] allocBytes(long var1, int var3);

    public byte[] allocAndClearBytes(long var1);

    public void free(byte[] var1);

    public byte[] getContentBytes(CacheID var1);

    public byte[] referencePersistentBytes(CacheID var1);

    public void putContentBytes(byte[] var1, CacheID var2);

    public void putContentBytes(byte[] var1, CacheID var2, int var3);

    public void addPersistentBytes(byte[] var1, CacheID var2);

    public void addPersistentBytes(byte[] var1, CacheID var2, int var3);

    public void releaseReference(CacheID var1);

    public void releaseModifiedReference(CacheID var1);

    public void releaseModifiedArrayReference(CacheID var1, long[] var2, long[] var3);

    public short[] allocShorts(long var1);

    public short[] allocShorts(long var1, int var3);

    public short[] allocAndClearShorts(long var1);

    public void free(short[] var1);

    public short[] getContentShorts(CacheID var1);

    public short[] referencePersistentShorts(CacheID var1);

    public void putContentShorts(short[] var1, CacheID var2);

    public void putContentShorts(short[] var1, CacheID var2, int var3);

    public void addPersistentShorts(short[] var1, CacheID var2);

    public void addPersistentShorts(short[] var1, CacheID var2, int var3);

    public int[] allocInts(long var1);

    public int[] allocInts(long var1, int var3);

    public int[] allocAndClearInts(long var1);

    public void free(int[] var1);

    public int[] getContentInts(CacheID var1);

    public int[] referencePersistentInts(CacheID var1);

    public void putContentInts(int[] var1, CacheID var2);

    public void putContentInts(int[] var1, CacheID var2, int var3);

    public void addPersistentInts(int[] var1, CacheID var2);

    public void addPersistentInts(int[] var1, CacheID var2, int var3);

    public float[] allocFloats(long var1);

    public float[] allocAndClearFloats(long var1);

    public void free(float[] var1);

    public float[] getContentFloats(CacheID var1);

    public float[] referencePersistentFloats(CacheID var1);

    public void putContentFloats(float[] var1, CacheID var2);

    public void addPersistentFloats(float[] var1, CacheID var2);

    public double[] allocDoubles(long var1);

    public double[] allocAndClearDoubles(long var1);

    public void free(double[] var1);

    public double[] getContentDoubles(CacheID var1);

    public double[] referencePersistentDoubles(CacheID var1);

    public void putContentDoubles(double[] var1, CacheID var2);

    public void addPersistentDoubles(double[] var1, CacheID var2);

    public Object allocObject(Class<?> var1, Object[] var2);

    public void free(Object var1);

    public Object getContentObject(CacheID var1);

    public Object referencePersistentObject(CacheID var1, Class<?> var2);

    public void putContentObject(Object var1, CacheID var2);

    public void addPersistentObject(Object var1, CacheID var2);

    public void addPersistentObject(Object var1, CacheID var2, int var3);

    public Iterator<ICacheItemGroup> listItemGroups();

    public boolean exists(Class<?> var1, CacheID var2);

    public boolean isInCache(Class<?> var1, CacheID var2);

    public boolean isInMemory(CacheID var1);

    public void remove(CacheID var1);

    public void flush(CacheID var1);

    public void flushGroup(Class<?> var1, CacheID var2);

    public void flushAll();

    public void ensureFreeMemory(long var1);

    public void addPersistentObject(Object var1, Class<?> var2, CacheID var3);

    public void setItemPriority(CacheID var1, int var2);

    public int getItemPriority(CacheID var1);

    public long availableMemory(int var1);

    public long getFreeMemory();

    public boolean isPoolActive(Object var1, CacheID var2);

    public File getFile(CacheID var1, Class<?> var2);

    public String getGroupAttribute(CacheID var1, Class<?> var2, String var3);

    public void setGroupAttribute(CacheID var1, Class<?> var2, String var3, String var4);

    public void deleteGroupAttribute(CacheID var1, Class<?> var2, String var3);
}

