/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports.ui;

import com.agfa.pacs.listtext.lta.base.mimeview.IComponentMimeView;
import com.agfa.pacs.listtext.lta.base.mimeview.IMimeView;
import com.agfa.pacs.listtext.lta.base.mimeview.IMimeViewProvider;
import com.agfa.pacs.listtext.lta.base.mimeview.MimeViewProviderFactory;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.listtext.lta.reports.ReportType;
import com.agfa.pacs.listtext.lta.reports.ui.IReportView;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.OpenLink;
import com.agfa.pacs.tools.StreamUtil;
import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import javax.swing.JComponent;
import org.dcm4che3.data.Attributes;

public class PDFReportView
implements IReportView {
    public static final String VIEW_TYPE = "PDF";
    public static final ReportType[] SUPPORTED_REPORT_TYPES = new ReportType[]{ReportType.PDFReport};
    private static final ALogger log = ALogger.getLogger(PDFReportView.class);
    private static final String tmpFileSuffix = ".pdf";
    private static final String tmpFilePrefix = "report";
    private IReport report = null;
    private File pdfFile = null;
    private IComponentMimeView pdfComponent = null;

    public PDFReportView(IReport iReport) {
        this.createComponents();
        this.init(iReport);
    }

    public PDFReportView() {
        this(null);
    }

    @Override
    public String getReportViewType() {
        return VIEW_TYPE;
    }

    @Override
    public Component getAWTRootComponent() {
        return this.pdfComponent != null ? this.pdfComponent.getAWTRootComponent() : null;
    }

    @Override
    public JComponent getPrintComponent() {
        return null;
    }

    @Override
    public boolean isReportTypeSupported(ReportType reportType) {
        return PDFReportView.supportsReport(reportType);
    }

    @Override
    public IReport getReport() {
        return this.report;
    }

    public static boolean supportsReport(ReportType reportType) {
        return Arrays.asList(SUPPORTED_REPORT_TYPES).contains((Object)reportType);
    }

    @Override
    public void init(IReport iReport) {
        this.report = iReport;
        this.initPDFView(iReport);
    }

    protected void createComponents() {
        IMimeViewProvider iMimeViewProvider = MimeViewProviderFactory.getInstance().getMimeViewProvider("application/pdf");
        if (iMimeViewProvider != null) {
            try {
                IMimeView iMimeView = iMimeViewProvider.createView();
                this.pdfComponent = (IComponentMimeView)iMimeView;
            }
            catch (Exception exception) {
                log.error("Creating PDF view component failed!");
            }
        }
    }

    protected void initPDFView(IReport iReport) {
        if (iReport != null) {
            try {
                Attributes attributes = iReport.getReportObject();
                this.deleteTempFile(this.pdfFile);
                this.pdfFile = this.createTempFile(attributes);
                if (this.pdfComponent != null) {
                    this.pdfComponent.showFile(this.pdfFile);
                } else {
                    OpenLink.openFile((File)this.pdfFile);
                }
            }
            catch (Exception exception) {
                log.error("PDF document creation or view initialization failed!", (Throwable)exception);
            }
        }
    }

    private void deleteTempFile(File file) {
        if (file != null && file.exists()) {
            file.delete();
        }
    }

    private File createTempFile(Attributes attributes) throws Exception {
        if (attributes != null) {
            int n = ThreadLocalRandom.current().nextInt();
            File file = File.createTempFile(tmpFilePrefix + Integer.toString(n), tmpFileSuffix);
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            StreamUtil.writeStream((byte[])attributes.getBytes(4325393), (OutputStream)fileOutputStream);
            fileOutputStream.close();
            return file;
        }
        return null;
    }

    @Override
    public void postInit() {
    }
}

