/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.listtext.lta.util.ImportUtils;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.dcm4che3.data.Attributes;

public enum ReportType {
    DoseReport(new String[]{"1.2.840.10008.5.1.4.1.1.88.67"}),
    OrbisReport(new String[]{"1.2.840.10008.5.1.4.1.1.88.11", "1.2.840.10008.5.1.4.1.1.88.22", "1.2.840.10008.5.1.4.1.1.88.33"}),
    TeachingFileReport(new String[]{"1.2.840.10008.5.1.4.1.1.88.11", "1.2.840.10008.5.1.4.1.1.88.22", "1.2.840.10008.5.1.4.1.1.88.33", "1.2.840.10008.5.1.4.1.1.88.40"}),
    MammoPreprocessingReport("1.2.840.10008.5.1.4.1.1.88.11"),
    CDAReport(new String[]{"1.2.840.10008.5.1.4.1.1.104.2"}),
    StructuredReport(new String[]{"1.2.840.10008.5.1.4.1.1.88.11", "1.2.840.10008.5.1.4.1.1.88.22", "1.2.840.10008.5.1.4.1.1.88.33", "1.2.840.10008.5.1.4.1.1.88.40"}),
    PDFReport("1.2.840.10008.5.1.4.1.1.104.1");

    private static final Code MAMMO_PREPROCESSING_CODE;
    private String[] sopClasses;

    static {
        MAMMO_PREPROCESSING_CODE = new Code("LN", "18000-3", null);
    }

    private ReportType(String[] stringArray) {
        this.sopClasses = stringArray;
    }

    private ReportType(String string2) {
        this(new String[]{string2});
    }

    public static ReportType getReportType(IObjectInfo iObjectInfo, boolean bl) {
        if (iObjectInfo != null) {
            ReportType[] reportTypeArray = ReportType.values();
            int n = reportTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ReportType reportType = reportTypeArray[n2];
                if (reportType.supportsReport(iObjectInfo, bl)) {
                    return reportType;
                }
                ++n2;
            }
        }
        return null;
    }

    private boolean supportsReport(IObjectInfo iObjectInfo, boolean bl) {
        if (Arrays.asList(this.sopClasses).contains(iObjectInfo.getSOPClassUID())) {
            if (DoseReport.equals((Object)this) && ReportType.isXRayRadiationDoseReport(iObjectInfo, bl)) {
                return true;
            }
            if (OrbisReport.equals((Object)this) && this.isOrbisReport(iObjectInfo, bl)) {
                return true;
            }
            if (CDAReport.equals((Object)this) && ReportType.isCDAReport(iObjectInfo, bl)) {
                return true;
            }
            if (TeachingFileReport.equals((Object)this) && ReportType.isTeachingFileReport(iObjectInfo)) {
                return true;
            }
            if (MammoPreprocessingReport.equals((Object)this) && ReportType.isMammoPreprocessingReport(iObjectInfo)) {
                return true;
            }
            if (StructuredReport.equals((Object)this) && !this.isQDocReport(iObjectInfo, bl)) {
                return true;
            }
            if (PDFReport.equals((Object)this) && this.isPDFReport(iObjectInfo, bl)) {
                return true;
            }
        }
        return false;
    }

    private boolean isQDocReport(IObjectInfo iObjectInfo, boolean bl) {
        String string;
        return iObjectInfo != null && "QDOC".equalsIgnoreCase(string = iObjectInfo.getAttributes().getString(524400));
    }

    private boolean isOrbisReport(IObjectInfo iObjectInfo, boolean bl) {
        String string;
        if (iObjectInfo != null && StringUtils.containsIgnoreCase((String)(string = iObjectInfo.getAttributes().getString(524400)), (String)"AGFA")) {
            return !ReportType.isTeachingFileReport(iObjectInfo) && !ReportType.isMammoPreprocessingReport(iObjectInfo);
        }
        return false;
    }

    private boolean isPDFReport(IObjectInfo iObjectInfo, boolean bl) {
        if (iObjectInfo != null) {
            if (bl) {
                ISeriesInfo iSeriesInfo = (ISeriesInfo)iObjectInfo.getTreeParent();
                if (iSeriesInfo != null) {
                    return !ImportUtils.isFileImport((Attributes)iSeriesInfo.getAttributes());
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private static boolean isTeachingFileReport(IObjectInfo iObjectInfo) {
        Code code;
        if (iObjectInfo.getAttributes().containsValue(4235331) && (code = Code.create((Attributes)iObjectInfo.getAttributes(), (int)4235331)) != null) {
            return "TCE006".equals(code.getCodeValue());
        }
        return false;
    }

    private static boolean isCDAReport(IObjectInfo iObjectInfo, boolean bl) {
        return "1.2.840.10008.5.1.4.1.1.104.2".equals(iObjectInfo.getSOPClassUID());
    }

    private static boolean isXRayRadiationDoseReport(IObjectInfo iObjectInfo, boolean bl) {
        Code code;
        if (iObjectInfo.getAttributes().containsValue(4235331) && (code = Code.create((Attributes)iObjectInfo.getAttributes(), (int)4235331)) != null) {
            return "1.2.840.10008.5.1.4.1.1.88.67".equals(iObjectInfo.getSOPClassUID());
        }
        return false;
    }

    private static boolean isMammoPreprocessingReport(IObjectInfo iObjectInfo) {
        if (iObjectInfo.getAttributes().containsValue(4235331)) {
            return MAMMO_PREPROCESSING_CODE.equals((Object)Code.create((Attributes)iObjectInfo.getAttributes(), (int)4235331));
        }
        return false;
    }
}

