/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.reports;

import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.listtext.lta.reports.IReport;
import com.agfa.pacs.listtext.lta.reports.IReportProvider;
import com.agfa.pacs.listtext.lta.reports.ReportProviderFactory;
import com.agfa.pacs.listtext.lta.reports.ReportType;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class ReportFactory {
    public static boolean supportsReport(IObjectInfo iObjectInfo) {
        ReportType reportType = ReportType.getReportType(iObjectInfo, true);
        if (reportType != null) {
            for (IReportProvider iReportProvider : ReportProviderFactory.getInstance().getReportProviders()) {
                List<ReportType> list = iReportProvider.getSupportedTypes();
                if (list == null || !list.contains((Object)reportType)) continue;
                return true;
            }
        }
        return false;
    }

    public static IReport createReport(IObjectInfo iObjectInfo, boolean bl) throws Exception {
        return ReportFactory.createReport(iObjectInfo, null, bl);
    }

    public static IReport createReport(IObjectInfo iObjectInfo, Attributes attributes, boolean bl) throws Exception {
        ReportType reportType = ReportType.getReportType(iObjectInfo, bl);
        List<IReportProvider> list = ReportProviderFactory.getInstance().getReportProviders(reportType);
        if (list != null && !list.isEmpty()) {
            return list.get(0).createReport(iObjectInfo, attributes);
        }
        throw new Exception("Report type not supported: " + (Object)((Object)reportType));
    }
}

