/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.integration.audit;

import com.agfa.integration.IDesktopIntegrationListener;
import com.agfa.integration.IntegrationFrameworkFactory;
import com.agfa.integration.ObjectID;
import com.agfa.integration.ext.ICommandMessage;
import com.agfa.integration.messages.AddToList;
import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.DateTimeUtils;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.listtext.lta.base.LTAUtil;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.integration.audit.DocumentRenderer;
import com.agfa.pacs.listtext.lta.integration.audit.EventType;
import com.agfa.pacs.listtext.swingx.controls.ClearableTextField;
import com.agfa.pacs.listtext.swingx.controls.DateBox;
import com.agfa.pacs.listtext.swingx.controls.MessageDialog;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.listtext.swingx.util.graphics.IconLoader;
import com.agfa.pacs.logging.ALogger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.time.DateUtils;
import org.lobobrowser.html.HtmlRendererContext;
import org.lobobrowser.html.UserAgentContext;
import org.lobobrowser.html.gui.HtmlPanel;
import org.lobobrowser.html.parser.DocumentBuilderImpl;
import org.lobobrowser.html.test.SimpleHtmlRendererContext;
import org.lobobrowser.html.test.SimpleUserAgentContext;
import org.w3c.dom.Document;
import org.w3c.dom.html2.HTMLElement;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class AuditLogViewer
extends JDialog {
    private static final ALogger log = ALogger.getLogger(AuditLogViewer.class);
    private static final String HTML_HIGHLIGHT_START = "<font style=\"background-color:#BBBB00;color:#000000\"><b>";
    private static final String HTML_HIGHLIGHT_END = "</b></font>";
    private static final String LINE_MARK_PREFIX = "line_";
    private static final String LINE_MARK_ID_STRING = "id=\"line_";
    private final int MINIMAL_SEARCH_QUERY_LENGTH = 2;
    private static final double WIDTH_FACTOR = 1.2;
    private static final double HEIGHT_FACTOR = 1.5;
    private static final double VERTICAL_POS = 1.2;
    private static final String DYNAMIC_COLOR_REGEX = "[^g]color\\s*=\\s*\"[0-9A-F]*\"";
    private static final String DYNAMIC_REPLACEMENT_COLOR = " color=\"000000\"";
    private static final String DEFAULT_COLOR_REGEX = "color\\s*:\\s*#DDDDDD";
    private static final String DEFAULT_REPLACEMENT_COLOR = "color:#000000";
    private static final String AUDIT_LOG_VIEWER_REPORT_PRINTNAME = "AuditLogViewer_Report_";
    private JPanel mainPane;
    private JPanel panelTopBar;
    private JLabel operationLabel;
    private JComboBox<EventType> operationsComboBox;
    private DateBox dateBox;
    private JButton buttonDayBefore;
    private JButton buttonDayAfter;
    private JButton buttonMonthBefore;
    private JButton buttonMonthAfter;
    private JButton buttonCurrentDay;
    private JButton buttonPrint;
    private JTextField studyInstanceUidTf;
    private HtmlPanel htmlView;
    private LinkListenerRenderContext rendererContext;
    private DocumentBuilderImpl htmlDocumentBuilder;
    private ClearableTextField searchQueryField;
    private Color searchQueryFieldBackgroundColor;
    boolean documentChanged = false;
    private String protocol = "http";
    private String host;
    private int port = 8080;
    private String path = "/arr/xml";
    private String dateTimeSeparator = "T";
    private URL queryURL;
    private StringWriter stringWriter;
    private String outputString;
    private String queryMessage;
    private InputStream iStreamXml;
    private Source xmlSource;
    private Source xslSource;
    private TransformerFactory transFact = TransformerFactory.newInstance();
    private Transformer trans;
    private static final EventType ALL = new EventType(0, Messages.getString("AuditLogDlg.EventTypeAll"));
    private List<EventType> eventTypeList;
    private String codeSystemName = "DCM";
    private String studyInstanceUID;
    private int[] eventIDs;
    private int[] eventTypeCodes;
    private boolean dateRestriction;
    private String specificUser;
    private String username;
    private String password;
    private boolean closeAfterLoading = false;
    private Pattern patRegexDynamic;
    private Pattern patRegexDefault;
    private PIcon iconPrint = PIconFactory.createdFixedSizeIconFactory((boolean)false, (int[])new int[]{16}).loadIcon(AuditLogViewer.class, "print.svg");

    public AuditLogViewer(String string, String string2, int[] nArray, int[] nArray2, boolean bl, String string3, String string4, String string5) {
        super(LTAUtil.getMainWindow(), Messages.getString("AuditLogDlg.Title"));
        if (string != null) {
            this.studyInstanceUID = string;
        }
        if (nArray != null) {
            this.eventIDs = nArray;
        }
        if (nArray2 != null) {
            this.eventTypeCodes = nArray2;
        }
        if (string2 != null) {
            this.specificUser = string2;
        }
        this.dateRestriction = bl;
        if (string3 != null) {
            this.username = string3;
        }
        if (string4 != null) {
            this.password = string4;
        }
        this.host = string5;
        Authenticator.setDefault(new HttpAuthenticator());
        this.xslSource = Locale.getDefault().getLanguage().equals(Locale.GERMAN.getLanguage()) ? new StreamSource(AuditLogViewer.class.getResourceAsStream("/Auditing_de.xsl")) : new StreamSource(AuditLogViewer.class.getResourceAsStream("/Auditing_en.xsl"));
        try {
            this.trans = this.transFact.newTransformer(this.xslSource);
        }
        catch (Exception exception) {
            log.error("Error transforming xsl source.", (Throwable)exception);
        }
        this.patRegexDynamic = Pattern.compile(DYNAMIC_COLOR_REGEX);
        this.patRegexDefault = Pattern.compile(DEFAULT_COLOR_REGEX);
        this.eventTypeList = new ArrayList<EventType>();
        this.eventTypeList.add(ALL);
        this.eventTypeList.add(new EventType(110103, "DICOM Instances Accessed"));
        this.eventTypeList.add(new EventType(110104, "DICOM Instances Transferred"));
        this.eventTypeList.add(new EventType(110105, "DICOM Study Deleted"));
        this.eventTypeList.add(new EventType(110106, "Data Export"));
        this.eventTypeList.add(new EventType(110107, "Data Import"));
    }

    public AuditLogViewer(String string, String string2, int[] nArray, int[] nArray2, boolean bl, String string3, String string4, String string5, boolean bl2) {
        this(string, string2, nArray, nArray2, bl, string3, string4, string5);
        this.closeAfterLoading = bl2;
    }

    public void showDialog() {
        EventUtil.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                AuditLogViewer.this.createAndShowGUI();
                AuditLogViewer.this.setVisible(true);
            }
        });
    }

    private String getQueryParameterPrefix() {
        String string = "?";
        String string2 = "&";
        if (!this.queryMessage.contains(string)) {
            return string;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private boolean generateQueryString() {
        this.queryMessage = "";
        if (this.dateRestriction) {
            String object2 = this.convertDateTimeSpecial(this.dateBox.getDate(), "00:00:00", this.dateTimeSeparator);
            String string = this.convertDateTimeSpecial(this.dateBox.getDate(), "23:59:59", this.dateTimeSeparator);
            if (object2 != null) {
                this.queryMessage = String.valueOf(this.queryMessage) + this.getQueryParameterPrefix() + "lowerDateTime=" + object2;
            }
            if (string != null) {
                this.queryMessage = String.valueOf(this.queryMessage) + this.getQueryParameterPrefix() + "upperDateTime=" + (String)string;
            }
        } else {
            if (this.studyInstanceUID != null) {
                this.studyInstanceUidTf.setText(this.studyInstanceUID);
                Dimension n = this.studyInstanceUidTf.getPreferredSize();
                this.studyInstanceUidTf.setPreferredSize(new Dimension(this.studyInstanceUID.length() * 10, n.height));
            } else {
                this.studyInstanceUidTf.setText("");
            }
            this.showAllComponentsIn(this.panelTopBar, false);
        }
        if (this.eventIDs != null) {
            void var1_5;
            boolean malformedURLException = false;
            while (var1_5 < this.eventIDs.length) {
                this.queryMessage = String.valueOf(this.queryMessage) + this.getQueryParameterPrefix() + "eventID=" + this.eventIDs[var1_5] + "^" + this.codeSystemName;
                ++var1_5;
            }
        } else if (this.operationsComboBox.getSelectedItem().equals(ALL)) {
            for (EventType eventType : this.eventTypeList) {
                if (eventType.getId() == 0) continue;
                this.queryMessage = String.valueOf(this.queryMessage) + this.getQueryParameterPrefix() + "eventID=" + eventType.getId() + "^" + this.codeSystemName;
            }
        } else {
            this.queryMessage = String.valueOf(this.queryMessage) + this.getQueryParameterPrefix() + "eventID=" + ((EventType)this.operationsComboBox.getSelectedItem()).getId() + "^" + this.codeSystemName;
        }
        if (this.eventTypeCodes != null) {
            void var1_9;
            boolean bl = false;
            while (var1_9 < this.eventTypeCodes.length) {
                this.queryMessage = String.valueOf(this.queryMessage) + this.getQueryParameterPrefix() + "eventTypeCode=" + this.eventTypeCodes[var1_9] + "^" + this.codeSystemName;
                ++var1_9;
            }
        }
        if (this.studyInstanceUID != null) {
            this.queryMessage = String.valueOf(this.queryMessage) + this.getQueryParameterPrefix() + "participantObjectID=" + this.studyInstanceUID;
        }
        if (this.specificUser != null) {
            this.queryMessage = String.valueOf(this.queryMessage) + this.getQueryParameterPrefix() + "userID=" + this.specificUser.toUpperCase(Locale.ENGLISH);
        }
        try {
            this.queryURL = new URL(this.protocol, this.host, this.port, String.valueOf(this.path) + this.queryMessage);
        }
        catch (MalformedURLException malformedURLException) {
            log.error("Error building query URL.", (Throwable)malformedURLException);
        }
        return true;
    }

    private JEditorPane getBWPane(String string) {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setContentType("text/html");
        jEditorPane.setEditable(false);
        jEditorPane.setOpaque(false);
        jEditorPane.setBorder(null);
        jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", false);
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
        jEditorPane.getDocument().putProperty("stream", null);
        jEditorPane.setDocument(hTMLDocument);
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        String string2 = ((FontUIResource)UIManager.get("FormattedTextField.font")).getFamily();
        StyleConstants.setFontFamily(simpleAttributeSet, string2);
        hTMLDocument.setCharacterAttributes(0, hTMLDocument.getLength(), simpleAttributeSet, false);
        String string3 = this.patRegexDefault.matcher(string).replaceAll(DEFAULT_REPLACEMENT_COLOR);
        string3 = this.patRegexDynamic.matcher(string3).replaceAll(DYNAMIC_REPLACEMENT_COLOR);
        jEditorPane.setText(string3);
        return jEditorPane;
    }

    private String getRenderableHtml(String string) {
        String string2 = string;
        string2 = string2.replaceFirst("<.xml version=\"1.0\" encoding=\"UTF-8\".>", "");
        return string2;
    }

    private void setHtmlText(String string) {
        try {
            String string2 = this.getRenderableHtml(string);
            Document document = this.htmlDocumentBuilder.parse(new InputSource(new StringReader(string2)));
            this.htmlView.setDocument(document, (HtmlRendererContext)this.rendererContext);
        }
        catch (SAXException sAXException) {
            log.error("Failed to parse the audit-html");
        }
        catch (IOException iOException) {
            log.error("Failed to read the audid-html into parser");
        }
    }

    private void generateHTML() {
        this.stringWriter = new StringWriter();
        try {
            this.xmlSource = new StreamSource(this.iStreamXml);
            if (this.xmlSource != null && this.trans != null) {
                this.trans.transform(this.xmlSource, new StreamResult(this.stringWriter));
                this.outputString = this.stringWriter.toString();
            } else {
                this.outputString = "";
            }
        }
        catch (TransformerException transformerException) {
            log.error("Error transforming stream source.", (Throwable)transformerException);
        }
    }

    private boolean getInfoFromWS() {
        HttpURLConnection httpURLConnection;
        block5: {
            block4: {
                int n = 0;
                httpURLConnection = (HttpURLConnection)this.queryURL.openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.connect();
                n = httpURLConnection.getResponseCode();
                if (n == 200) break block4;
                String string = httpURLConnection.getResponseMessage();
                log.error("Http URL connection to host " + this.host + " failed. Error code " + n + ": " + string + '.');
                MessageDialog messageDialog = MessageDialog.createMessageDialog((Component)LTAUtil.getMainWindow(), (String)Messages.getString("AuditLogDlg.URLConnectionFailedMessageTitle"), (Object)new JLabel(Messages.getString("AuditLogDlg.URLConnectionFailedMessage")), (boolean)true, (int)2, (String)"OK_OPTION");
                messageDialog.showCenteredInComponent((Component)this.getParent());
                return false;
            }
            String string = httpURLConnection.getContentType();
            if (string.contains("text/xml")) break block5;
            log.error("Content type mismatch. " + string + " found where 'text/xml' expected!");
            return false;
        }
        try {
            this.iStreamXml = httpURLConnection.getInputStream();
        }
        catch (IOException iOException) {
            log.error("Error opening URL connection.", (Throwable)iOException);
        }
        return true;
    }

    private void updateQuery() {
        CursorUtil.setWaitCursor((Component)this);
        try {
            this.generateQueryString();
            this.getInfoFromWS();
            this.generateHTML();
            if (this.searchQueryField.getText().length() >= 2) {
                this.documentChanged = true;
                this.updateSearchHighlighting();
            } else {
                this.setHtmlText(this.outputString);
            }
        }
        finally {
            CursorUtil.resetWaitCursor((Component)this);
        }
    }

    private String convertDateTimeSpecial(Date date, String string, String string2) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String string3 = simpleDateFormat.format(date);
        if (string == null) {
            string = DateTimeUtils.time2LongerString((Date)date);
        }
        String string4 = String.valueOf(string3) + string2 + string;
        return string4;
    }

    private void createAndShowGUI() {
        this.mainPane = new JPanel(new BorderLayout());
        this.getContentPane().add((Component)this.mainPane, "Center");
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setSize(Math.max(dimension2.width, (int)((double)dimension.width / 1.2)), Math.max(dimension2.height, (int)((double)dimension.height / 1.5)));
        dimension2 = this.getSize();
        this.setLocationRelativeTo(LTAUtil.getMainWindow());
        this.addComponentsToPanel(this.mainPane);
    }

    private void addComponent(JPanel jPanel, int n, int n2, int n3, Component component) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        jPanel.add(component, gridBagConstraints);
    }

    private void addComponentsToPanel(JPanel jPanel) {
        this.panelTopBar = new JPanel(new GridBagLayout());
        jPanel.add((Component)this.panelTopBar, "North");
        if (this.studyInstanceUID != null) {
            this.studyInstanceUidTf = new JTextField(this.studyInstanceUID);
            this.studyInstanceUidTf.setEditable(false);
            this.studyInstanceUidTf.setHorizontalAlignment(0);
            this.addComponent(this.panelTopBar, -1, 0, 1, this.studyInstanceUidTf);
        }
        if (this.eventIDs == null) {
            this.operationLabel = new JLabel(Messages.getString("AuditLogDlg.Operation"));
            this.addComponent(this.panelTopBar, 0, 0, 1, this.operationLabel);
            this.operationsComboBox = new JComboBox();
            for (EventType object2 : this.eventTypeList) {
                this.operationsComboBox.addItem(object2);
            }
            this.addComponent(this.panelTopBar, 1, 0, 1, this.operationsComboBox);
            this.operationsComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AuditLogViewer.this.updateQuery();
                }
            });
        }
        this.buttonMonthBefore = new JButton(new MonthBefore());
        this.buttonMonthBefore.setAlignmentX(1.0f);
        this.addComponent(this.panelTopBar, -1, 0, 1, this.buttonMonthBefore);
        this.buttonDayBefore = new JButton(new DayBefore());
        this.buttonDayBefore.setAlignmentX(1.0f);
        this.addComponent(this.panelTopBar, -1, 0, 1, this.buttonDayBefore);
        this.dateBox = new DateBox();
        this.dateBox.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("DATE_VALUE_CHANGED".equals(propertyChangeEvent.getPropertyName())) {
                    AuditLogViewer.this.updateQuery();
                }
            }
        });
        this.addComponent(this.panelTopBar, -1, 0, 1, (Component)this.dateBox);
        this.buttonDayAfter = new JButton(new DayAfter());
        this.addComponent(this.panelTopBar, -1, 0, 1, this.buttonDayAfter);
        this.buttonMonthAfter = new JButton(new MonthAfter());
        this.addComponent(this.panelTopBar, -1, 0, 1, this.buttonMonthAfter);
        this.buttonCurrentDay = new JButton(new DayCurrent());
        this.addComponent(this.panelTopBar, -1, 0, 1, this.buttonCurrentDay);
        this.buttonPrint = new JButton(new ActionPrint());
        this.addComponent(this.panelTopBar, -1, 0, 1, this.buttonPrint);
        JSeparator jSeparator = new JSeparator(1);
        this.addComponent(this.panelTopBar, -1, 0, 1, jSeparator);
        this.searchQueryField = new ClearableTextField();
        this.searchQueryField.setInfoText(Messages.getString("AuditLogViewer.SearchInfoText"));
        this.searchQueryField.setPreferredSize(new Dimension(200, 25));
        this.searchQueryField.getDocument().addDocumentListener(new SearchQueryDocumentListener());
        this.searchQueryFieldBackgroundColor = this.searchQueryField.getBackground();
        this.addComponent(this.panelTopBar, -1, 0, 1, (Component)this.searchQueryField);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                AuditLogViewer.this.searchQueryField.requestFocusInWindow();
            }
        });
        this.htmlView = new HtmlPanel();
        this.initHtmlParser();
        this.updateQuery();
        jPanel.add((Component)this.htmlView, "Center");
    }

    private void showAllComponentsIn(JPanel jPanel, boolean bl) {
        Component[] componentArray = jPanel.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof JPanel) {
                this.showAllComponentsIn((JPanel)componentArray[n], bl);
            } else if (!(componentArray[n] instanceof JTextField)) {
                componentArray[n].setVisible(bl);
            }
            ++n;
        }
    }

    private void initHtmlParser() {
        Logger.getLogger("org.lobobrowser").setLevel(Level.SEVERE);
        SimpleUserAgentContext simpleUserAgentContext = new SimpleUserAgentContext();
        this.rendererContext = new LinkListenerRenderContext(this.htmlView, (UserAgentContext)simpleUserAgentContext);
        this.htmlDocumentBuilder = new DocumentBuilderImpl((UserAgentContext)simpleUserAgentContext, (HtmlRendererContext)this.rendererContext);
    }

    void addToList(ObjectID objectID, IDesktopIntegrationListener.AddOption addOption) {
        AddToList addToList = new AddToList(objectID, addOption, false);
        IntegrationFrameworkFactory.getInstance().queueCommand((ICommandMessage)addToList);
    }

    private void searchUpdate() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CursorUtil.setWaitCursor((Component)AuditLogViewer.this);
                try {
                    AuditLogViewer.this.updateSearchHighlighting();
                }
                finally {
                    CursorUtil.resetWaitCursor((Component)AuditLogViewer.this);
                }
            }
        });
    }

    private void setQueryNotFoundColor() {
        if (LTAUtil.isOnColorMonitor()) {
            this.searchQueryField.setBackground(new Color(255, 102, 102));
        } else {
            this.searchQueryField.setBackground(new Color(205, 205, 205));
        }
    }

    private void setQueryFoundColor() {
        this.searchQueryField.setBackground(this.searchQueryFieldBackgroundColor);
    }

    private void updateSearchHighlighting() {
        String string = this.searchQueryField.getText().toLowerCase(Locale.getDefault());
        boolean bl = false;
        if (string.length() >= 2) {
            int n;
            int n2;
            String string2 = this.outputString;
            String string3 = this.outputString.toLowerCase(Locale.getDefault());
            int n3 = string3.indexOf("id=\"line_1");
            int n4 = 0;
            int n5 = -1;
            while (n3 > -1) {
                if ((n3 = string3.indexOf(string, n3)) <= -1) continue;
                n2 = string3.indexOf("<", n3);
                if (n2 <= (n = string3.indexOf(">", n3))) {
                    if (n5 == -1) {
                        n5 = n3;
                    }
                    string2 = this.injectHighlighting(string2, string, n3 + n4);
                    n4 += HTML_HIGHLIGHT_START.length() + HTML_HIGHLIGHT_END.length();
                }
                n3 += string.length();
            }
            if (n5 > -1) {
                this.setHtmlText(string2);
                n2 = string3.lastIndexOf(LINE_MARK_ID_STRING, n5);
                if (n2 > -1 && (n = string3.indexOf("\"", n2 += LINE_MARK_ID_STRING.length())) > -1) {
                    String string4 = LINE_MARK_PREFIX + string3.substring(n2, n);
                    this.htmlView.validate();
                    this.htmlView.scrollToElement(string4);
                }
                this.setQueryFoundColor();
                this.documentChanged = true;
            } else {
                bl = true;
                this.setQueryNotFoundColor();
            }
        } else {
            bl = true;
            this.setQueryFoundColor();
        }
        if (bl && this.documentChanged) {
            this.setHtmlText(this.outputString);
            this.documentChanged = false;
        }
    }

    private String injectHighlighting(String string, String string2, int n) {
        return String.valueOf(string.substring(0, n)) + HTML_HIGHLIGHT_START + string.substring(n, n + string2.length()) + HTML_HIGHLIGHT_END + string.substring(n + string2.length());
    }

    private class ActionPrint
    extends AbstractAction {
        public ActionPrint() {
            super(null, (Icon)AuditLogViewer.this.iconPrint);
            super.putValue("ShortDescription", Messages.getString("AuditLogDlg.PrintTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            DocumentRenderer documentRenderer = new DocumentRenderer();
            documentRenderer.setPageFormatOrientation(0);
            documentRenderer.setPrintJobName(AuditLogViewer.AUDIT_LOG_VIEWER_REPORT_PRINTNAME + DateTimeUtils.date2String((Date)AuditLogViewer.this.dateBox.getDate()));
            String string = AuditLogViewer.this.getRenderableHtml(AuditLogViewer.this.outputString);
            documentRenderer.print(AuditLogViewer.this.getBWPane(string));
        }
    }

    private class DayAfter
    extends AbstractAction {
        public DayAfter() {
            super(null, IconLoader.getIcon((String)"/icons/audit_day_after.gif", (ClassLoader)AuditLogViewer.class.getClassLoader(), (double)GUI.getScaleFactor()));
            super.putValue("ShortDescription", Messages.getString("AuditLogDlg.DayAfterTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Date date = DateUtils.addDays((Date)AuditLogViewer.this.dateBox.getDate(), (int)1);
            AuditLogViewer.this.dateBox.setDate(date);
        }
    }

    private class DayBefore
    extends AbstractAction {
        public DayBefore() {
            super(null, IconLoader.getIcon((String)"/icons/audit_day_before.gif", (ClassLoader)AuditLogViewer.class.getClassLoader(), (double)GUI.getScaleFactor()));
            super.putValue("ShortDescription", Messages.getString("AuditLogDlg.DayBeforeTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Date date = DateUtils.addDays((Date)AuditLogViewer.this.dateBox.getDate(), (int)-1);
            AuditLogViewer.this.dateBox.setDate(date);
        }
    }

    private class DayCurrent
    extends AbstractAction {
        public DayCurrent() {
            super(Messages.getString("AuditLogDlg.DayCurrent"));
            super.putValue("ShortDescription", Messages.getString("AuditLogDlg.DayCurrentTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AuditLogViewer.this.dateBox.setDate(Calendar.getInstance().getTime());
        }
    }

    class HttpAuthenticator
    extends Authenticator {
        HttpAuthenticator() {
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            log.debug("Feeding username and password for " + this.getRequestingScheme());
            return new PasswordAuthentication(AuditLogViewer.this.username, AuditLogViewer.this.password.toCharArray());
        }
    }

    private class LinkListenerRenderContext
    extends SimpleHtmlRendererContext {
        public LinkListenerRenderContext(HtmlPanel htmlPanel, UserAgentContext userAgentContext) {
            super(htmlPanel, userAgentContext);
        }

        public void linkClicked(HTMLElement hTMLElement, URL uRL, String string) {
            if (Product.isPasta()) {
                return;
            }
            String string2 = uRL.toString().replace("http://", "");
            String[] stringArray = string2.split(",");
            int n = 0;
            while (n < stringArray.length) {
                ObjectID objectID = ObjectID.forStudyUID((String)stringArray[n]);
                try {
                    AuditLogViewer.this.addToList(objectID, IDesktopIntegrationListener.AddOption.AddAndOpen);
                    if (AuditLogViewer.this.closeAfterLoading) {
                        AuditLogViewer.this.dispose();
                    }
                }
                catch (Exception exception) {
                    log.error("Could not open given study: " + stringArray[n], (Throwable)exception);
                }
                ++n;
            }
        }
    }

    private class MonthAfter
    extends AbstractAction {
        public MonthAfter() {
            super(null, IconLoader.getIcon((String)"/icons/audit_month_after.gif", (ClassLoader)AuditLogViewer.class.getClassLoader(), (double)GUI.getScaleFactor()));
            super.putValue("ShortDescription", Messages.getString("AuditLogDlg.MonthAfterTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Date date = DateUtils.addMonths((Date)AuditLogViewer.this.dateBox.getDate(), (int)1);
            AuditLogViewer.this.dateBox.setDate(date);
        }
    }

    private class MonthBefore
    extends AbstractAction {
        public MonthBefore() {
            super(null, IconLoader.getIcon((String)"/icons/audit_month_before.gif", (ClassLoader)AuditLogViewer.class.getClassLoader(), (double)GUI.getScaleFactor()));
            super.putValue("ShortDescription", Messages.getString("AuditLogDlg.MonthBeforeTT"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Date date = DateUtils.addMonths((Date)AuditLogViewer.this.dateBox.getDate(), (int)-1);
            AuditLogViewer.this.dateBox.setDate(date);
        }
    }

    private class SearchQueryDocumentListener
    implements DocumentListener {
        private SearchQueryDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            AuditLogViewer.this.searchUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            AuditLogViewer.this.searchUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            AuditLogViewer.this.searchUpdate();
        }
    }
}

