/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.worklists;

import com.agfa.pacs.base.data.action.DataActionFactory;
import com.agfa.pacs.base.data.action.IDataAction;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.worklist.IWorklistContext;
import com.agfa.pacs.listtext.lta.base.worklists.INormalizedWorklistProvider;
import com.agfa.pacs.listtext.lta.base.worklists.NormalizedWorklistProviderFactory;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NormalizedAddToWorklistAction
implements IDataAction {
    private static final ALogger log = ALogger.getLogger(NormalizedAddToWorklistAction.class);

    public boolean isAllowed() {
        return !NormalizedWorklistProviderFactory.get().getProviders().isEmpty();
    }

    public String getActionCode() {
        return "ADD_TO_WORKLIST";
    }

    public int getPriority() {
        return 0;
    }

    public int perform(IDataAction.IActionContext iActionContext, List<? extends IDataInfo> list) {
        List<IWorklistContext> list2;
        if (iActionContext != null && list != null && !list.isEmpty() && !(list2 = NormalizedAddToWorklistAction.getWorklistContexts(iActionContext)).isEmpty()) {
            int n = 0;
            for (IWorklistContext iWorklistContext : list2) {
                if (this.addToWorklist(iActionContext.getUIContext(), iActionContext.getMonitor(), iWorklistContext, list) >= 0) continue;
                n = -1;
            }
            return n;
        }
        return -1;
    }

    private int addToWorklist(Component component, Rectangle rectangle, IWorklistContext iWorklistContext, List<? extends IDataInfo> list) {
        IDataAction iDataAction;
        String string = NormalizedAddToWorklistAction.isLegacyContext(iWorklistContext) ? NormalizedAddToWorklistAction.getAddToLegacyWorklistActionCode(iWorklistContext.getType()) : (NormalizedAddToWorklistAction.isUWLContext(iWorklistContext) ? NormalizedAddToWorklistAction.getAddToUWLActionCode(iWorklistContext.getType()) : null);
        IDataAction iDataAction2 = iDataAction = string != null ? DataActionFactory.getInstance().getActionForCode(string) : null;
        if (iDataAction != null) {
            return iDataAction.perform((IDataAction.IActionContext)new IDataAction.DefaultActionContext(component, (Object)iWorklistContext, rectangle), list);
        }
        log.warn("Adding data to worklist of type {} failed! No supporting data action found...", (Object)iWorklistContext.getType());
        return -1;
    }

    private static List<IWorklistContext> getWorklistContexts(IDataAction.IActionContext iActionContext) {
        Object object = iActionContext.getExecutionContext();
        ArrayList<IWorklistContext> arrayList = new ArrayList<IWorklistContext>();
        if (object instanceof IWorklistContext) {
            arrayList.add((IWorklistContext)object);
        } else if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                if (!(e instanceof IWorklistContext) || arrayList.contains(e)) continue;
                arrayList.add((IWorklistContext)e);
            }
        }
        return arrayList;
    }

    private static boolean isLegacyContext(IWorklistContext iWorklistContext) {
        INormalizedWorklistProvider iNormalizedWorklistProvider = NormalizedWorklistProviderFactory.get().getProvider(iWorklistContext.getType());
        if (iNormalizedWorklistProvider != null) {
            return INormalizedWorklistProvider.ImplementationType.LEGACY.equals((Object)iNormalizedWorklistProvider.getImplementationType());
        }
        return false;
    }

    private static boolean isUWLContext(IWorklistContext iWorklistContext) {
        INormalizedWorklistProvider iNormalizedWorklistProvider = NormalizedWorklistProviderFactory.get().getProvider(iWorklistContext.getType());
        if (iNormalizedWorklistProvider != null) {
            return INormalizedWorklistProvider.ImplementationType.UWL.equals((Object)iNormalizedWorklistProvider.getImplementationType());
        }
        return false;
    }

    public static String getAddToLegacyWorklistActionCode(String string) {
        return "ADD_TO_LEGACY_WORKLIST";
    }

    public static String getAddToUWLActionCode(String string) {
        return "ADD_TO_UWL_WORKIST" + "_" + string;
    }
}

