/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.tagdictionary;

import com.agfa.pacs.listtext.lta.base.tagdictionary.Tag;
import java.util.Arrays;
import java.util.List;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public class DicomTag
extends Tag {
    private static final String xmlName = DicomTag.classBaseName(DicomTag.class);
    protected int number;

    public Integer getNumber() {
        return this.number;
    }

    public void setNumber(Integer n) {
        this.number = n;
    }

    public DicomTag(String string, String string2, Integer n) {
        super(string, string2);
        this.setNumber(n);
    }

    public DicomTag() {
        this.number = -1;
    }

    public String tagNumberAsFormatedString() {
        return TagUtils.toString((int)this.number);
    }

    public String tagName() {
        return xmlName;
    }

    @Override
    public String getVr() {
        return ElementDictionary.vrOf((int)this.number, null).toString();
    }

    @Override
    public VR getVRType() {
        return ElementDictionary.vrOf((int)this.number, null);
    }

    @Override
    public String toString() {
        return String.valueOf(this.tagNumberAsFormatedString()) + ": " + this.description;
    }

    @Override
    public void setVr(String string) {
    }

    public static int[] extractTags(List<DicomTag> list) {
        int[] nArray = new int[list.size()];
        int n = 0;
        while (n < list.size()) {
            nArray[n] = list.get((int)n).number;
            ++n;
        }
        Arrays.sort(nArray);
        return nArray;
    }
}

