/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect.task;

import com.agfa.pacs.background.IBackgroundProgress;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.listtext.lta.base.connect.IStudySharePermissionOptions;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareConfig;
import com.agfa.pacs.listtext.lta.base.connect.StudyShareParameter;
import com.agfa.pacs.listtext.lta.base.connect.exception.StudyShareAuthenticationException;
import com.agfa.pacs.listtext.lta.base.connect.exception.StudyShareException;
import com.agfa.pacs.logging.ALogger;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.dcm4che3.util.UIDUtils;

abstract class AbstractStudyShareTask
implements IBackgroundTask {
    protected final ALogger log;
    final IStudySharePermissionOptions options;
    private final String uid = UIDUtils.createUID();
    private IBackgroundProgress listener;
    private String sessionCookie;
    private String failureMessage;

    AbstractStudyShareTask(IStudySharePermissionOptions iStudySharePermissionOptions) {
        this.log = ALogger.getLogger(this.getClass());
        this.options = iStudySharePermissionOptions;
    }

    AbstractStudyShareTask(IStudySharePermissionOptions iStudySharePermissionOptions, String string) {
        this(iStudySharePermissionOptions);
        this.sessionCookie = string;
    }

    public void terminate() {
    }

    public void take(IBackgroundProgress iBackgroundProgress) {
        this.listener = iBackgroundProgress;
    }

    void executeTask() throws IOException, StudyShareException {
        this.setProgress(0.1);
        URL uRL = new URL(this.getRequestURL());
        if (this.sessionCookie == null) {
            this.sessionCookie = this.createSessionCookie(uRL);
        }
        if (this.sessionCookie == null) {
            throw new StudyShareAuthenticationException();
        }
        this.setProgress(0.25);
        RetrySettings retrySettings = this.getRetrySettings();
        int n = retrySettings.getRetryCount() + 1;
        double d = 0.75 / (double)n;
        int n2 = 0;
        while (n2 < n) {
            double d2 = 0.3 + d * (double)n2;
            this.setProgress(d2);
            if (this.executeTaskImpl(uRL, d2, d / 4.0)) {
                this.log.debug("Study share task successfully completed.");
                break;
            }
            if (n2 < n - 1) {
                long l = retrySettings.getRetryDelay();
                if (this.log.isDebugEnabled()) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Delaying retry #");
                    stringBuilder.append(n2 + 1);
                    stringBuilder.append(" of ");
                    stringBuilder.append(n - 1);
                    stringBuilder.append(" by ");
                    stringBuilder.append(l);
                    stringBuilder.append("ms");
                    this.log.debug(stringBuilder.toString());
                }
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    this.log.warn("Retry delay interrupted.", (Throwable)interruptedException);
                }
            } else {
                this.log.warn("Aborting after maximum number of retries.");
            }
            ++n2;
        }
        this.setProgress(1.0);
    }

    private boolean executeTaskImpl(URL uRL, double d, double d2) throws IOException, StudyShareException {
        HttpURLConnection httpURLConnection = null;
        try {
            this.log.trace("Connecting to Internet study share server ...");
            httpURLConnection = this.openConnectionForHttpPost(uRL, this.sessionCookie, new IHttpURLConnectionConfigurator[0]);
            this.setProgress(d + d2);
            this.log.trace("Sending request to Internet study share server ...");
            this.sendRequest(httpURLConnection, this.getRequestParameters());
            this.setProgress(d + 2.0 * d2);
            int n = httpURLConnection.getResponseCode();
            if (n == 501) {
                this.log.debug("Received HTTP status code {}, retrying ...", (Object)n);
                return false;
            }
            if (n != 200) {
                throw new IOException("HTTP request failed with status code " + n);
            }
            this.setProgress(d + 3.0 * d2);
            this.log.trace("Reading response from Internet study share server ...");
            boolean bl = this.readResponse(httpURLConnection);
            return bl;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    void setProgress(double d) {
        if (this.listener != null) {
            this.listener.progress(d);
        }
    }

    void setFailureMessage(String string) {
        this.failureMessage = string;
        if (this.listener != null) {
            this.listener.progress(1.0, string);
        }
    }

    String getFailureMessage() {
        return this.failureMessage;
    }

    private String getRequestURL() {
        return this.getInternalURL(this.getRequestURLPath());
    }

    String getInternalURL(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StudyShareConfig.getInternalURL());
        if (stringBuilder.charAt(stringBuilder.length() - 1) != '/') {
            stringBuilder.append('/');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    abstract String getRequestURLPath();

    abstract Map<StudyShareParameter, String> getRequestParameters();

    String getSessionCookie() {
        return this.sessionCookie;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String createSessionCookie(URL uRL) throws IOException {
        this.log.debug("Creating session cookie ...");
        HttpURLConnection httpURLConnection = null;
        try {
            httpURLConnection = this.openConnectionForHttpPost(uRL, null, new IHttpURLConnectionConfigurator[0]);
            this.sendRequest(httpURLConnection, this.getRequestParameters());
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                return null;
            }
            if (!httpURLConnection.getContentType().startsWith("text/html")) {
                return null;
            }
            String string = httpURLConnection.getHeaderField("Set-Cookie");
            if (string == null) return null;
            if (!string.startsWith("JSESSIONID=")) {
                return null;
            }
            string = string.substring(0, string.indexOf(59));
            URL uRL2 = httpURLConnection.getURL();
            httpURLConnection.disconnect();
            httpURLConnection = null;
            String string2 = uRL2.getPath();
            String string3 = string2.substring(string2.lastIndexOf(47) + 1);
            string2 = string2.substring(0, string2.lastIndexOf(47));
            string2 = String.valueOf(string2) + "/j_security_check";
            uRL2 = new URL(uRL2.getProtocol(), uRL2.getHost(), uRL2.getPort(), string2);
            httpURLConnection = this.openConnectionForHttpPost(uRL2, string, new AuthenticationHttpURLConnectionConfigurator());
            this.sendRequest(httpURLConnection, StudyShareConfig.getAuthenticationParameters());
            int n2 = httpURLConnection.getResponseCode();
            if (n2 != 200) return null;
            String string4 = httpURLConnection.getURL().toString();
            if (!string4.endsWith(string3)) return null;
            String string5 = string;
            return string5;
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private HttpURLConnection openConnectionForHttpPost(URL uRL, String string, IHttpURLConnectionConfigurator ... iHttpURLConnectionConfiguratorArray) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        if (string != null) {
            httpURLConnection.setRequestProperty("Cookie", string);
        }
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        IHttpURLConnectionConfigurator[] iHttpURLConnectionConfiguratorArray2 = iHttpURLConnectionConfiguratorArray;
        int n = iHttpURLConnectionConfiguratorArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHttpURLConnectionConfigurator iHttpURLConnectionConfigurator = iHttpURLConnectionConfiguratorArray2[n2];
            iHttpURLConnectionConfigurator.configureConnection(httpURLConnection);
            ++n2;
        }
        httpURLConnection.connect();
        return httpURLConnection;
    }

    private void sendRequest(HttpURLConnection httpURLConnection, Map<? extends Object, String> map) throws IOException {
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream());
            boolean bl = true;
            for (Map.Entry<? extends Object, String> entry : map.entrySet()) {
                if (bl) {
                    bl = false;
                } else {
                    outputStreamWriter.write(38);
                }
                outputStreamWriter.write(entry.getKey().toString());
                outputStreamWriter.write(61);
                outputStreamWriter.write(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            outputStreamWriter.flush();
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    this.log.warn("Closing HTTP output stream failed.", (Throwable)iOException);
                }
            }
        }
    }

    abstract RetrySettings getRetrySettings();

    abstract boolean readResponse(HttpURLConnection var1) throws IOException, StudyShareException;

    public String getUID() {
        return this.uid;
    }

    private static class AuthenticationHttpURLConnectionConfigurator
    implements IHttpURLConnectionConfigurator {
        private AuthenticationHttpURLConnectionConfigurator() {
        }

        @Override
        public void configureConnection(HttpURLConnection httpURLConnection) {
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.setAllowUserInteraction(true);
            httpURLConnection.setUseCaches(false);
        }
    }

    private static interface IHttpURLConnectionConfigurator {
        public void configureConnection(HttpURLConnection var1);
    }

    static class RetrySettings {
        static final RetrySettings DEFAULT = new RetrySettings(2, 500L, false);
        private final int retryCount;
        private final long retryDelay;
        private final boolean isInsufficientStudyPermissionRetryEnabled;

        RetrySettings(int n, long l, boolean bl) {
            this.retryCount = n;
            this.retryDelay = l;
            this.isInsufficientStudyPermissionRetryEnabled = bl;
        }

        boolean isInsufficientStudyPermissionRetryEnabled() {
            return this.isInsufficientStudyPermissionRetryEnabled;
        }

        int getRetryCount() {
            return this.retryCount;
        }

        long getRetryDelay() {
            return this.retryDelay;
        }
    }
}

