/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.IStudySharePermissionOptions;
import com.agfa.pacs.listtext.lta.base.connect.IStudyShareSettings;
import com.agfa.pacs.listtext.lta.base.connect.StudySharePermission;
import com.agfa.pacs.listtext.swingx.controls.DateBox;
import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class StudySharePermissionOptions
extends JPanel
implements IStudySharePermissionOptions {
    private final IComponentFactory componentFactory;
    private final DateBox expirationDate;
    private final ButtonGroup permissionsGroup;
    private final Map<ButtonModel, StudySharePermission> permissionsMap;

    StudySharePermissionOptions(IComponentFactory iComponentFactory, IStudyShareSettings iStudyShareSettings, boolean bl) {
        this.componentFactory = iComponentFactory;
        this.expirationDate = new DateBox();
        this.permissionsGroup = new ButtonGroup();
        this.permissionsMap = new HashMap<ButtonModel, StudySharePermission>();
        this.init(iStudyShareSettings.getExpirationDate(), iStudyShareSettings.getPermission(), bl);
    }

    @Override
    public Date getExpirationDate() {
        return this.expirationDate.getDate();
    }

    @Override
    public StudySharePermission getPermission() {
        return this.permissionsMap.get(this.permissionsGroup.getSelection());
    }

    private void init(Date date, StudySharePermission studySharePermission, boolean bl) {
        int n = this.componentFactory.scaleInt(10);
        TableLayout tableLayout = new TableLayout(new double[]{-2.0, -2.0}, new double[]{-2.0, n});
        tableLayout.setHGap(n);
        this.setLayout((LayoutManager)tableLayout);
        this.add((Component)new JLabel(String.valueOf(Messages.getString("StudySharePermissionOptions.ExpirationDate")) + ':'), "0,0");
        this.add((Component)this.expirationDate, "1,0");
        this.expirationDate.setDate(date);
        this.expirationDate.setEnabled(bl);
        int n2 = 2;
        StudySharePermission[] studySharePermissionArray = StudySharePermission.values();
        int n3 = studySharePermissionArray.length;
        int n4 = 0;
        while (n4 < n3) {
            StudySharePermission studySharePermission2 = studySharePermissionArray[n4];
            JRadioButton jRadioButton = this.componentFactory.createRadioButton(studySharePermission2.toString());
            jRadioButton.setEnabled(bl);
            this.permissionsGroup.add(jRadioButton);
            this.permissionsGroup.setSelected(jRadioButton.getModel(), studySharePermission == studySharePermission2);
            this.permissionsMap.put(jRadioButton.getModel(), studySharePermission2);
            tableLayout.insertRow(n2, -2.0);
            this.add((Component)jRadioButton, "1," + n2);
            ++n2;
            ++n4;
        }
        if (!this.permissionsMap.isEmpty()) {
            this.add((Component)new JLabel(String.valueOf(Messages.getString("StudySharePermissionOptions.Permission")) + ':'), "0,2");
        }
    }
}

