/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.connect;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.connect.IStudyShareSettings;
import com.agfa.pacs.listtext.lta.base.connect.StudySharePermission;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.URLProviderFactory;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class StudyShareConfig {
    static final ALogger LOGGER = ALogger.getLogger(StudyShareConfig.class);
    private static final IConfigurationProvider CONFIG = ConfigurationProviderFactory.getConfig().getNode("listtext.lta.base.connect");
    private static IStudyShareSettings DEFAULT_SETTINGS = new DefaultStudyShareSettings();
    private static final String DEFAULT_USER_ID = "R20_ExtFrei";

    private StudyShareConfig() {
    }

    static boolean getUseSeparateArchive() {
        return CONFIG.getBoolean("useSeparateArchive");
    }

    static String getDestinationAET() {
        return CONFIG.getString("aet");
    }

    public static String getInternalURL() {
        return CONFIG.getString("internalURL");
    }

    public static String getExternalBaseURL() {
        return CONFIG.getString("externalBaseURL");
    }

    public static Map<String, String> getAuthenticationParameters() {
        String string;
        String string2;
        if (CONFIG.getBoolean("authentication.isReuseEnabled")) {
            string2 = URLProviderFactory.getProvider().getLoginInformation().getUserID();
            string = URLProviderFactory.getProvider().getLoginInformation().getPassword();
        } else {
            string2 = CONFIG.getString("authentication.user");
            string = CONFIG.getString("authentication.password");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("login", "Login");
        hashMap.put("j_username", string2);
        hashMap.put("j_password", string);
        return hashMap;
    }

    public static String getUserId() {
        String string = CONFIG.getString("userId");
        if (string == null || string.trim().length() == 0) {
            string = DEFAULT_USER_ID;
        }
        return string;
    }

    static IStudyShareSettings getDefaultSettings() {
        return DEFAULT_SETTINGS;
    }

    static boolean isQRCodeEnabledByDefault() {
        return CONFIG.getBoolean("isQRCodeEnabled");
    }

    static boolean isPrintEnabled() {
        return CONFIG.getBoolean("isPrintEnabled");
    }

    static String getDefaultDepartmentName() {
        return ConfigurationProviderFactory.getConfig().getString("listtext.import.departmentName");
    }

    public static PatientIdentificationType getPatientIdentificationType() {
        return PatientIdentificationType.fromString(CONFIG.getString("patientIdentificationType"));
    }

    private static class DefaultStudyShareSettings
    implements IStudyShareSettings {
        private DefaultStudyShareSettings() {
        }

        private int getDefaultExpirationDuration() {
            return (int)CONFIG.getLong("defaultExpiration");
        }

        @Override
        public Date getExpirationDate() {
            Calendar calendar = Calendar.getInstance();
            calendar.add(5, this.getDefaultExpirationDuration());
            return calendar.getTime();
        }

        @Override
        public StudySharePermission getPermission() {
            StudySharePermission studySharePermission = StudySharePermission.VIEW;
            try {
                studySharePermission = StudySharePermission.valueOf(CONFIG.getString("defaultPermission"));
            }
            catch (Exception exception) {
                LOGGER.error("Reading default share study permission from config failed.", (Throwable)exception);
            }
            return studySharePermission;
        }
    }

    public static enum PatientIdentificationType {
        NONE,
        PATIENT_NAME,
        PATIENT_INITIALS,
        PATIENT_ID;


        public static PatientIdentificationType fromString(String string) {
            if (NONE.name().equals(string)) {
                return NONE;
            }
            if (PATIENT_NAME.name().equals(string)) {
                return PATIENT_NAME;
            }
            if (PATIENT_INITIALS.name().equals(string)) {
                return PATIENT_INITIALS;
            }
            if (PATIENT_ID.name().equals(string)) {
                return PATIENT_ID;
            }
            throw new IllegalArgumentException("Unknown Patient Identification Type: " + string);
        }

        public String toString() {
            return Messages.getString("PatientIdentificationType." + this.name());
        }
    }
}

