/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.about.plaf.basic;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.layout.RowLayout;
import com.agfa.pacs.base.swing.util.CursorUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.listtext.lta.base.LTAComponentFactory;
import com.agfa.pacs.listtext.lta.base.LTAUtil;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.base.about.About;
import com.agfa.pacs.listtext.lta.base.about.IAboutModelListener;
import com.agfa.pacs.listtext.lta.base.about.LicenseMapFactory;
import com.agfa.pacs.listtext.lta.base.about.cemark.CEMarkProviderFactory;
import com.agfa.pacs.listtext.lta.base.about.cemark.ICEMarkProvider;
import com.agfa.pacs.listtext.lta.base.about.plaf.AboutUI;
import com.agfa.pacs.listtext.swingx.icon.PIcon;
import com.agfa.pacs.listtext.swingx.icon.PIconFactory;
import com.agfa.pacs.listtext.swingx.util.SwingUtilities2;
import com.agfa.pacs.logging.ALogger;
import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.URL;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class BasicAboutUI
extends AboutUI {
    public static final ALogger log = ALogger.getLogger(BasicAboutUI.class);
    private static final PIconFactory iconFactory = new PIconFactory((IComponentFactory)LTAComponentFactory.instance, 16);
    private static final PIcon manufacturerIcon = iconFactory.loadIcon(BasicAboutUI.class, "/icons/Manufacturer.svg");
    protected About about = null;
    protected JLabel vendorIconLabel = null;
    protected JLabel manufacturerLabel = null;
    protected JTextArea licenseTypeDescArea = null;
    protected JLabel agfaCEIconLabel = null;
    protected JScrollPane licenseTypeDescSCP = null;
    private JPanel headPanel = null;
    protected JLabel licenseTypeLabel = null;
    protected JLabel licenseInformation = null;
    private JPanel cePanel = null;
    private JPanel ceIconPanel = null;
    private JScrollPane ceIconScrollPane = null;
    protected JButton okBtn = null;
    protected JPanel buttonPanel = null;
    protected JPanel backgroundPanel = null;
    protected JPanel dialogPanel = null;
    protected JDialog aboutDlg = null;
    private JLabel vendorName = null;
    private JLabel vendorAddress = null;
    private JLabel copyright = null;
    private JTabbedPane tabbedPane = null;
    private JPanel componentsInnerPanel = null;
    private JEditorPane creditsEditorPane = null;
    private JScrollPane editorScrollPane = null;
    private JScrollPane componentsScrollPane = null;
    private JPanel vendorPanel = null;
    private IAboutModelListener aboutListener = null;
    private InputListener inputListener = null;
    protected Color primaryBgColor = null;
    protected Color secondaryBgColor = null;
    private IComponentFactory factory = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicAboutUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.about = (About)((Object)jComponent);
        this.factory = this.about.getComponentFactory();
        this.installDefaults();
        this.createComponents();
        this.createListeners();
        this.installListeners();
        this.initComponents();
        this.installLayout();
    }

    public void uninstallUI() {
        this.uninstallLayout();
        this.uninstallListeners();
        this.uninstallDefaults();
        this.about = null;
    }

    @Override
    public void showModalAboutDialog(Component component) {
        Window window = component == null ? LTAUtil.getMainWindow() : SwingUtilities2.windowForComponent((Component)component);
        CursorUtil.setWaitCursor((Component)component);
        try {
            this.aboutDlg = this.createDialog(window);
            this.aboutDlg.setTitle(About.getTitle());
            this.aboutDlg.setLayout(new BorderLayout());
            this.aboutDlg.add((Component)this.backgroundPanel, "Center");
            this.aboutDlg.setSize(this.factory.scaleDimension(600, 770));
            this.factory.centerOnOwner((Window)this.aboutDlg);
            this.aboutDlg.setModal(true);
            this.aboutDlg.setVisible(true);
        }
        finally {
            CursorUtil.resetWaitCursor((Component)component);
        }
    }

    protected void installDefaults() {
        this.primaryBgColor = UIManager.getColor("color.primary.1");
        this.secondaryBgColor = UIManager.getColor("color.secondary.2");
    }

    protected void uninstallDefaults() {
        this.primaryBgColor = null;
        this.secondaryBgColor = null;
    }

    protected void createComponents() {
        this.headPanel = this.factory.createPanel(null);
        this.vendorIconLabel = this.factory.createLabel(null);
        this.vendorIconLabel.setHorizontalAlignment(4);
        this.licenseTypeLabel = this.factory.createLabel(null);
        this.licenseInformation = this.factory.createLabel(null);
        this.manufacturerLabel = this.factory.createLabel((Icon)manufacturerIcon);
        this.okBtn = this.factory.createButton("   " + Messages.getString("BasicAboutUI.AboutDlg_Close") + "   ");
        this.vendorPanel = this.factory.createPanel(null);
        this.cePanel = this.factory.createPanel(null);
        this.ceIconPanel = this.factory.createPanel(null);
        this.ceIconScrollPane = this.factory.createScrollPane((Component)this.ceIconPanel);
        this.ceIconScrollPane.setPreferredSize(GUI.getScaledDimension((Dimension)new Dimension(500, 88)));
        this.ceIconScrollPane.setVerticalScrollBarPolicy(20);
        this.ceIconScrollPane.setHorizontalScrollBarPolicy(30);
        this.buttonPanel = this.factory.createPanel(null);
        this.dialogPanel = this.factory.createPanel(null);
        this.backgroundPanel = this.createBackgroundPanel();
        this.licenseTypeDescArea = this.factory.createTextArea();
        this.componentsInnerPanel = this.factory.createPanel(null);
        this.creditsEditorPane = this.createCreditsEditorPane();
        this.factory.scaleFont((Component)this.creditsEditorPane);
        this.editorScrollPane = this.factory.createScrollPane((Component)this.creditsEditorPane);
        this.editorScrollPane.setVerticalScrollBarPolicy(20);
        this.editorScrollPane.setHorizontalScrollBarPolicy(30);
        this.componentsScrollPane = this.factory.createScrollPane((Component)this.componentsInnerPanel);
        this.componentsScrollPane.setVerticalScrollBarPolicy(20);
        this.componentsScrollPane.setHorizontalScrollBarPolicy(30);
        this.tabbedPane = this.factory.createTabbedPane(Integer.valueOf(1), Integer.valueOf(0));
        this.licenseTypeDescSCP = this.factory.createScrollPane((Component)this.licenseTypeDescArea);
        this.agfaCEIconLabel = this.factory.createLabel(null);
        this.vendorName = this.factory.createLabel(null);
        this.vendorAddress = this.factory.createLabel(null);
        this.copyright = this.factory.createLabel(null);
    }

    protected void createListeners() {
        this.aboutListener = new AboutListener();
        this.inputListener = new InputListener();
    }

    protected void installListeners() {
        this.about.addAboutModelListener(this.aboutListener);
        this.okBtn.addActionListener(this.inputListener);
    }

    protected void uninstallListeners() {
        this.about.removeAboutModelListener(this.aboutListener);
        this.okBtn.removeActionListener(this.inputListener);
    }

    protected void initComponents() {
        this.dialogPanel.setBackground(this.primaryBgColor);
        this.licenseTypeLabel.setText(String.valueOf(this.about.getProductTitle()) + " " + this.about.getProductVersion());
        this.licenseInformation.setText(this.about.getLicensingInformation());
        Image image = this.about.getVendorImage();
        this.vendorIconLabel.setIcon(image != null ? new ImageIcon(image.getScaledInstance(image.getWidth(null) / 2, image.getHeight(null) / 2, 2)) : null);
        this.vendorIconLabel.setToolTipText(System.getProperty("user.dir"));
        Image image2 = this.about.getCEImage();
        this.agfaCEIconLabel.setIcon(image2 != null ? new ImageIcon(image2.getScaledInstance(image2.getWidth(null), image2.getHeight(null), 2)) : null);
        this.initHtmlView(this.creditsEditorPane);
        this.creditsEditorPane.setText(this.transformXml());
        this.vendorName.setText(Product.getProductVendor());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>");
        stringBuilder.append(Product.getOwnerInfo()[1]);
        stringBuilder.append("<br />");
        stringBuilder.append(Product.getOwnerInfo()[2]);
        stringBuilder.append("<br />");
        stringBuilder.append(Product.getOwnerInfo()[3]);
        stringBuilder.append("</html>");
        this.vendorAddress.setText(stringBuilder.toString());
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        calendar.setTime(this.about.getProductFirstReleaseDate());
        calendar2.setTime(this.about.getProductLastReleaseDate());
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(Messages.getString("BasicAboutUI.Copyright"));
        stringBuilder2.append(' ');
        stringBuilder2.append(calendar.get(1));
        stringBuilder2.append(" - ");
        stringBuilder2.append(calendar2.get(1));
        this.copyright.setText(stringBuilder2.toString());
    }

    protected void installLayout() {
        this.licenseTypeDescArea.setOpaque(false);
        this.licenseTypeLabel.setFont(this.licenseTypeLabel.getFont().deriveFont(1, this.licenseTypeLabel.getFont().getSize() + 2));
        this.componentsScrollPane.setBorder(new LineBorder(Color.black, 1, true));
        this.editorScrollPane.setBorder(new LineBorder(Color.black, 1, true));
        this.creditsEditorPane.setSelectionStart(0);
        this.creditsEditorPane.setSelectionEnd(0);
        this.creditsEditorPane.setOpaque(false);
        this.creditsEditorPane.setBackground(new Color(0, 0, 0, 0));
        try {
            this.setLayoutComponentsInnerPanel();
        }
        catch (Exception exception) {
            log.error("Error on setting thirdparty licenses: ", (Throwable)exception);
        }
        this.tabbedPane.addTab(Messages.getString("BasicAboutUI.Credits"), this.editorScrollPane);
        this.tabbedPane.addTab(Messages.getString("BasicAboutUI.Components"), this.componentsScrollPane);
        this.setCEIconPanelLayout();
        this.headPanel.setLayout(new GridBagLayout());
        this.headPanel.add((Component)this.licenseTypeLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.headPanel.add((Component)this.vendorIconLabel, new GridBagConstraints(1, 0, 1, 2, 1.0, 0.0, 12, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.headPanel.add((Component)this.licenseInformation, new GridBagConstraints(0, 1, 0, 0, 1.0, 0.0, 18, 2, new Insets(15, 0, 25, 0), 0, 0));
        this.vendorPanel.setLayout(new GridBagLayout());
        this.vendorPanel.add((Component)this.agfaCEIconLabel, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 7), 0, 0));
        this.vendorPanel.add((Component)this.manufacturerLabel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 5), 0, 0));
        this.vendorPanel.add((Component)this.vendorName, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.vendorPanel.add((Component)this.vendorAddress, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.vendorPanel.add((Component)this.copyright, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 10, 0), 0, 0));
        this.buttonPanel.setLayout(new FlowLayout(1, 0, 5));
        this.buttonPanel.add(this.okBtn);
        TableLayout tableLayout = new TableLayout(new double[]{-1.0}, new double[]{-2.0, -2.0, -2.0, -1.0, -2.0});
        this.dialogPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 5, 20));
        this.dialogPanel.setLayout((LayoutManager)tableLayout);
        this.dialogPanel.add((Component)this.headPanel, "0,0");
        this.dialogPanel.add((Component)this.vendorPanel, "0,1");
        this.dialogPanel.add((Component)this.cePanel, "0,2");
        this.dialogPanel.add((Component)this.tabbedPane, "0,3");
        this.dialogPanel.add((Component)this.buttonPanel, "0,4");
        this.backgroundPanel.setLayout(new BorderLayout());
        this.backgroundPanel.add((Component)this.dialogPanel, "Center");
        this.about.setLayout(new BorderLayout());
        this.about.add(this.backgroundPanel, "Center");
    }

    private void setCEIconPanelLayout() {
        Iterable<ICEMarkProvider> iterable = CEMarkProviderFactory.getInstance().getCEMarkProviders();
        if (iterable.iterator().hasNext()) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.ceIconPanel.setLayout(new GridBagLayout());
            this.ceIconPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            int n = 0;
            for (ICEMarkProvider object2 : iterable) {
                if (!object2.showProvider()) continue;
                Image image = object2.getCEMark();
                ImageIcon imageIcon = new ImageIcon(image.getScaledInstance(image.getWidth(null), image.getHeight(null), 2));
                JLabel jLabel = this.factory.createLabel((Icon)imageIcon);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = n;
                gridBagConstraints.gridheight = 3;
                gridBagConstraints.anchor = 18;
                gridBagConstraints.fill = 2;
                gridBagConstraints.insets = new Insets(0, 0, 0, 7);
                if (Product.isReleasedVersion()) {
                    this.ceIconPanel.add((Component)jLabel, gridBagConstraints);
                }
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.insets = new Insets(0, 0, 0, 5);
                JLabel jLabel2 = this.factory.createLabel((Icon)manufacturerIcon);
                this.ceIconPanel.add((Component)jLabel2, gridBagConstraints);
                gridBagConstraints.gridx = 2;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                JLabel jLabel3 = this.factory.createLabel(object2.getName());
                this.ceIconPanel.add((Component)jLabel3, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.gridy = ++n;
                JLabel jLabel4 = this.factory.createLabel(object2.getVersion());
                this.ceIconPanel.add((Component)jLabel4, gridBagConstraints);
                gridBagConstraints.gridy = ++n;
                gridBagConstraints.insets = new Insets(0, 0, 15, 0);
                JLabel jLabel5 = this.factory.createLabel(object2.getAddress());
                this.ceIconPanel.add((Component)jLabel5, gridBagConstraints);
                ++n;
            }
            JLabel jLabel = this.factory.createLabel(null);
            jLabel.setText(Messages.getString("BasicAboutUI.IntegratedComponents"));
            this.cePanel.setLayout((LayoutManager)new RowLayout());
            this.cePanel.setBorder(BorderFactory.createEmptyBorder(15, 0, 10, 0));
            this.cePanel.add(jLabel);
            this.cePanel.add(this.ceIconScrollPane);
        }
    }

    protected void uninstallLayout() {
        this.about.removeAll();
    }

    protected JEditorPane createCreditsEditorPane() {
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        jEditorPane.setContentType("text/html");
        jEditorPane.setBorder(null);
        return jEditorPane;
    }

    protected JPanel createBackgroundPanel() {
        JPanel jPanel = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paintComponent(Graphics graphics) {
                if (graphics instanceof Graphics2D) {
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Insets insets = this.getInsets();
                    int n = this.getWidth();
                    int n2 = this.getHeight();
                    Paint paint = graphics2D.getPaint();
                    GradientPaint gradientPaint = new GradientPaint(insets.left, insets.top, BasicAboutUI.this.primaryBgColor, insets.left + n, insets.top + n2, BasicAboutUI.this.secondaryBgColor);
                    graphics2D.setPaint(gradientPaint);
                    graphics2D.fillRect(insets.left, insets.top, n, n2);
                    graphics2D.setPaint(paint);
                } else {
                    super.paintComponent(graphics);
                }
            }
        };
        return jPanel;
    }

    protected JDialog createDialog(Window window) {
        return new JDialog(window);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String transformXml() {
        try {
            Object object;
            Object object2;
            InputStream inputStream2 = null;
            InputStream inputStream = null;
            try {
                object2 = BasicAboutUI.class.getResource("/credits_" + Locale.getDefault().getLanguage() + ".xml");
                if (object2 == null) {
                    object2 = BasicAboutUI.class.getResource("/credits.xml");
                }
                object = BasicAboutUI.class.getResource("/credits.xsl");
                if (object2 == null) return "";
                if (object == null) {
                    return "";
                }
                inputStream2 = ((URL)object2).openStream();
                inputStream = ((URL)object).openStream();
            }
            catch (IOException iOException) {
                log.error("Cannot find xml/xsl credits resource");
                return "";
            }
            object2 = new StreamSource(inputStream2);
            object = new StreamSource(inputStream);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            StringWriter stringWriter = new StringWriter();
            String string = "";
            try {
                try {
                    Transformer transformer = transformerFactory.newTransformer((Source)object);
                    transformer.transform((Source)object2, new StreamResult(stringWriter));
                    string = stringWriter.toString();
                    string = string.replaceFirst("<.xml version=\"1.0\" encoding=\"UTF-8\".>", "");
                    return string;
                }
                catch (TransformerException transformerException) {
                    log.error("Error on transforming xslt source: ", (Throwable)transformerException);
                    this.closeStream(inputStream2);
                    this.closeStream(inputStream);
                    return string;
                }
            }
            finally {
                this.closeStream(inputStream2);
                this.closeStream(inputStream);
            }
        }
        catch (Exception exception) {
            log.error("Credits cannot be shown: ", (Throwable)exception);
            return "";
        }
    }

    private void closeStream(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            log.debug("Closing stream failed: ", (Throwable)iOException);
        }
    }

    private void setLayoutComponentsInnerPanel() {
        TableLayout tableLayout = new TableLayout(new double[]{-3.0, -1.0}, new double[]{-2.0, -2.0});
        this.componentsInnerPanel.setLayout((LayoutManager)tableLayout);
        this.componentsInnerPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 0, 0));
        TableLayoutConstraints tableLayoutConstraints = new TableLayoutConstraints();
        tableLayoutConstraints.col1 = 0;
        tableLayoutConstraints.col2 = 0;
        tableLayoutConstraints.row1 = 0;
        tableLayoutConstraints.row2 = 0;
        tableLayoutConstraints.hAlign = 0;
        tableLayoutConstraints.vAlign = 1;
        int n = 0;
        Map<String, List<URL>> map = LicenseMapFactory.createLicenseMap(this.about);
        if (map != null) {
            for (Map.Entry<String, List<URL>> entry : map.entrySet()) {
                JLabel jLabel = this.factory.createLabel("<html><u>" + entry.getKey() + "</u></html>");
                jLabel.setCursor(Cursor.getPredefinedCursor(12));
                final File file = LicenseMapFactory.createMergedLicenseFile(entry);
                if (file != null) {
                    jLabel.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            if (mouseEvent.getClickCount() > 0) {
                                try {
                                    Desktop.getDesktop().open(file);
                                }
                                catch (Exception exception) {
                                    log.error("Error on opening license.", (Throwable)exception);
                                }
                            }
                        }
                    });
                }
                tableLayoutConstraints.row1 = n;
                tableLayoutConstraints.row2 = n;
                tableLayout.insertRow(n, 20.0);
                this.componentsInnerPanel.add((Component)jLabel, tableLayoutConstraints);
                ++n;
            }
        }
    }

    private void initHtmlView(JEditorPane jEditorPane) {
        HTMLEditorKit hTMLEditorKit = new HTMLEditorKit();
        HTMLDocument hTMLDocument = (HTMLDocument)hTMLEditorKit.createDefaultDocument();
        jEditorPane.getDocument().putProperty("stream", null);
        jEditorPane.setDocument(hTMLDocument);
        hTMLDocument.setCharacterAttributes(0, hTMLDocument.getLength(), this.createHtmlAttributeSet(), false);
    }

    private AttributeSet createHtmlAttributeSet() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        String string = ((FontUIResource)UIManager.get("FormattedTextField.font")).getFontName();
        StyleConstants.setFontFamily(simpleAttributeSet, string);
        return simpleAttributeSet;
    }

    private class AboutListener
    implements IAboutModelListener {
        private AboutListener() {
        }

        @Override
        public void copyrightNoticeChanged(Object object) {
        }

        @Override
        public void licenseTypeChanged(Object object) {
            BasicAboutUI.this.licenseTypeLabel.setText(object != null ? object.toString() : "");
        }

        @Override
        public void licenseTypeDescriptionChanged(Object object) {
            BasicAboutUI.this.licenseTypeDescArea.setText(object != null ? object.toString() : "");
        }
    }

    private class InputListener
    implements ActionListener {
        private InputListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == BasicAboutUI.this.okBtn && BasicAboutUI.this.aboutDlg != null) {
                BasicAboutUI.this.aboutDlg.setVisible(false);
            }
        }
    }
}

