/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base.about;

import com.agfa.pacs.listtext.lta.base.about.About;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.StreamUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.osgi.framework.Bundle;

public class LicenseMapFactory {
    public static final ALogger log = ALogger.getLogger(LicenseMapFactory.class);
    private static final String SEARCHSTRING = "thirdparty";

    public static Map<String, List<URL>> createLicenseMap(About about) {
        TreeMap<String, List<URL>> treeMap = new TreeMap<String, List<URL>>();
        for (BundleDescription bundleDescription : about.getInstalledBundles()) {
            Enumeration enumeration;
            Bundle bundle;
            if (bundleDescription.getName() == null || !bundleDescription.getName().contains(SEARCHSTRING) || (bundle = Platform.getBundle((String)bundleDescription.getName())) == null || (enumeration = bundle.findEntries("/", "LICENSE*.txt", true)) == null) continue;
            LinkedList<URL> linkedList = new LinkedList<URL>();
            while (enumeration.hasMoreElements()) {
                linkedList.add((URL)enumeration.nextElement());
            }
            String string = bundle.getHeaders().get("Bundle-Name").toString();
            string = string.replace(" ", "&nbsp;");
            treeMap.put(string, linkedList);
        }
        return treeMap;
    }

    public static File createMergedLicenseFile(Map.Entry<String, List<URL>> entry) {
        File file;
        block13: {
            file = null;
            String string = "line.separator";
            OutputStreamWriter outputStreamWriter = null;
            try {
                try {
                    file = File.createTempFile("LICENSE", ".txt");
                    file.deleteOnExit();
                    outputStreamWriter = new FileWriter(file);
                    for (URL uRL : entry.getValue()) {
                        InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
                        String string2 = StreamUtil.readStream((Reader)inputStreamReader);
                        outputStreamWriter.write(string2);
                        outputStreamWriter.write(System.getProperty(string));
                        outputStreamWriter.write(System.getProperty(string));
                        outputStreamWriter.write(System.getProperty(string));
                        outputStreamWriter.write(System.getProperty(string));
                        outputStreamWriter.write(System.getProperty(string));
                        inputStreamReader.close();
                    }
                }
                catch (IOException iOException) {
                    log.error("Error on merging license files", (Throwable)iOException);
                    if (outputStreamWriter == null) break block13;
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException2) {
                        log.debug("Closing file failed: " + outputStreamWriter, (Throwable)iOException2);
                    }
                }
            }
            finally {
                if (outputStreamWriter != null) {
                    try {
                        outputStreamWriter.close();
                    }
                    catch (IOException iOException) {
                        log.debug("Closing file failed: " + outputStreamWriter, (Throwable)iOException);
                    }
                }
            }
        }
        return file;
    }
}

