/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.base;

import com.agfa.pacs.base.swing.util.FocusUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.data.shared.filter.FilterLevel;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import com.agfa.pacs.listtext.lta.base.Messages;
import com.agfa.pacs.listtext.lta.util.DicomTagDictionaryFactory;
import com.agfa.pacs.listtext.swingx.plaf.LookAndFeelManager;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.login.LoginSessionFactory;
import com.agfa.pacs.login.URLProviderFactory;
import com.agfa.pacs.tools.StreamUtil;
import java.awt.Window;
import java.io.InputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.swing.JFrame;

public class LTAUtil {
    private static final ALogger log = ALogger.getLogger(LTAUtil.class);
    private static final boolean isMonochromeMonitor = LookAndFeelManager.getInstance().isMonochromeLookAndFeel();
    private static boolean colorMonitor = true;
    private static Window mainWindow = null;
    private static Double servicesVersion;

    public static Window getMainWindow() {
        return mainWindow;
    }

    public static void setMainWindow(Window window) {
        mainWindow = window;
        colorMonitor = LTAUtil.isOnColorMonitorImpl();
    }

    public static void minimizeMainWindow() {
        if (mainWindow instanceof JFrame) {
            JFrame jFrame = (JFrame)mainWindow;
            jFrame.setState(1);
        }
    }

    public static void requestFocus() {
        FocusUtil.activateWindow((Window)mainWindow, (FocusUtil.WindowAction)FocusUtil.WindowAction.ToFrontAndRequestFocus);
    }

    private static boolean isOnColorMonitorImpl() {
        if (isMonochromeMonitor) {
            return false;
        }
        return GUI.isOnColorMonitor((Window)mainWindow);
    }

    public static boolean isOnColorMonitor() {
        return colorMonitor;
    }

    public static double getWebServicesVersion() {
        if (servicesVersion == null) {
            servicesVersion = LTAUtil.findServicesVersion();
        }
        return servicesVersion;
    }

    public static DataInfoLevel getDataInfoLevel(IDataInfo iDataInfo) {
        if (iDataInfo == null) {
            return null;
        }
        if (iDataInfo instanceof IRootInfo) {
            return DataInfoLevel.ROOT;
        }
        if (iDataInfo instanceof IPatientInfo) {
            return DataInfoLevel.PATIENT;
        }
        if (iDataInfo instanceof IStudyInfo) {
            return DataInfoLevel.STUDY;
        }
        if (iDataInfo instanceof ISeriesInfo) {
            return DataInfoLevel.SERIES;
        }
        if (iDataInfo instanceof IObjectInfo) {
            return DataInfoLevel.OBJECT;
        }
        return null;
    }

    public static DataInfoLevel getDataInfoLevelForDicomTag(int n) {
        return LTAUtil.getDataInfoLevelForFilterLevel(DicomTagDictionaryFactory.getDictionary().getLevelForTag(n));
    }

    public static DataInfoLevel getDataInfoLevelForFilterLevel(FilterLevel filterLevel) {
        if (filterLevel == FilterLevel.Default) {
            return DataInfoLevel.ROOT;
        }
        if (filterLevel == FilterLevel.Patient) {
            return DataInfoLevel.PATIENT;
        }
        if (filterLevel == FilterLevel.Study) {
            return DataInfoLevel.STUDY;
        }
        if (filterLevel == FilterLevel.Series) {
            return DataInfoLevel.SERIES;
        }
        if (filterLevel == FilterLevel.Image) {
            return DataInfoLevel.OBJECT;
        }
        return null;
    }

    public static Class<? extends IDataInfo> getDataInfoClass(DataInfoLevel dataInfoLevel) {
        if (dataInfoLevel == null) {
            return null;
        }
        if (dataInfoLevel == DataInfoLevel.ROOT) {
            return IRootInfo.class;
        }
        if (dataInfoLevel == DataInfoLevel.PATIENT) {
            return IPatientInfo.class;
        }
        if (dataInfoLevel == DataInfoLevel.STUDY) {
            return IStudyInfo.class;
        }
        if (dataInfoLevel == DataInfoLevel.SERIES) {
            return ISeriesInfo.class;
        }
        if (dataInfoLevel == DataInfoLevel.OBJECT) {
            return IObjectInfo.class;
        }
        return null;
    }

    public static void refreshExpandedWorklist() {
        LTAUtil.refreshExpandedWorklist(false);
    }

    public static void refreshExpandedWorklist(boolean bl) {
        IEventEngine iEventEngine = EventEngineFactory.getInstance();
        int n = iEventEngine.getEventID("LISTAREA_REFRESH_EXPANDED_WORKLIST");
        IEvent iEvent = iEventEngine.createEvent(n, null, null, (Serializable)((Object)"LTA"), ActionInfo.SINGLE);
        iEvent.setDestination(null, "lta.listarea.ui");
        iEvent.setPayload((Object)bl);
        iEventEngine.sendEvent(iEvent);
    }

    public static void studyStatusChanged(IStudyInfo iStudyInfo) {
        IEventEngine iEventEngine = EventEngineFactory.getInstance();
        int n = iEventEngine.getEventID("STUDY_STATUS_CHANGED");
        IEvent iEvent = iEventEngine.createEvent(n, null, null, (Serializable)((Object)"LTA"), ActionInfo.SINGLE);
        iEvent.setDestination(null, "lta.listarea.ui");
        iEvent.setPayload((Object)iStudyInfo);
        iEventEngine.sendEvent(iEvent);
    }

    private static double findServicesVersion() {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(String.valueOf(URLProviderFactory.getProvider().getServerUrl()) + "lta/common?action=version");
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            LoginSessionFactory.getSession().attach(httpURLConnection);
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setDoOutput(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.connect();
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                String string = new String(StreamUtil.readStream((InputStream)httpURLConnection.getInputStream()));
                double d = Double.parseDouble(string);
                return d;
            }
        }
        catch (Exception exception) {
            log.error("Could not obtain web services version!", (Throwable)exception);
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
        return 1.0;
    }

    public static enum DataInfoLevel {
        ROOT,
        PATIENT,
        STUDY,
        SERIES,
        OBJECT;


        public String toString() {
            return Messages.getString("DataInfoLevel." + this.name());
        }
    }
}

