/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.clinicalcode.acr.node;

import com.agfa.pacs.listtext.clinicalcode.acr.ACRCode;
import com.agfa.pacs.listtext.clinicalcode.acr.code.ACRCodeFactory;
import com.agfa.pacs.listtext.clinicalcode.acr.data.ACRCodeRawData;
import com.agfa.pacs.listtext.clinicalcode.acr.node.ACRAnatomyNode;
import com.agfa.pacs.listtext.clinicalcode.acr.node.ACRPathologyNode;
import com.agfa.pacs.logging.ALogger;
import java.util.Comparator;
import java.util.TreeSet;

public class ACRNodeFactory {
    public static ACRAnatomyNode createAnatomyRoot() {
        Object object;
        String[] stringArray;
        TreeSet<ACRCode> treeSet = new TreeSet<ACRCode>(new ACRCodeComparator());
        Object object2 = stringArray = ACRCodeRawData.getRawDataAnatomy();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            treeSet.add(ACRNodeFactory.createAnatomyCode((String)object));
            ++n2;
        }
        object = new ACRAnatomyNode(ACRCodeFactory.createAnatomyInstance("-1", "Anatomy"));
        for (ACRCode aCRCode : treeSet) {
            object2 = ACRNodeFactory.createAnatomyNode(aCRCode);
            ((ACRAnatomyNode)object).addChild((ACRAnatomyNode)object2);
        }
        return object;
    }

    public static ACRPathologyNode createPathologyRoot(ACRAnatomyNode aCRAnatomyNode) {
        Object object;
        String[] stringArray;
        int n = 0;
        if (aCRAnatomyNode != null) {
            try {
                n = Integer.parseInt(aCRAnatomyNode.getCode().getId().substring(0, 1));
            }
            catch (Exception exception) {
                ALogger.getLogger(ACRNodeFactory.class).warn(null, (Throwable)exception);
            }
        } else {
            return null;
        }
        TreeSet<ACRCode> treeSet = new TreeSet<ACRCode>(new ACRCodeComparator());
        Object object2 = stringArray = ACRCodeRawData.getRawDataPathology(n);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = object2[n3];
            treeSet.add(ACRNodeFactory.createPathologyCode((String)object));
            ++n3;
        }
        object = new ACRPathologyNode(ACRCodeFactory.createPathologyInstance("-1", "Pathology"), aCRAnatomyNode);
        for (ACRCode aCRCode : treeSet) {
            object2 = ACRNodeFactory.createPathologyNode(aCRCode, aCRAnatomyNode);
            ((ACRPathologyNode)object).addChild((ACRPathologyNode)object2);
        }
        return object;
    }

    private static ACRCode createAnatomyCode(String string) {
        String[] stringArray = string.split(";");
        return ACRCodeFactory.createAnatomyInstance(stringArray[1], stringArray[0]);
    }

    private static ACRCode createPathologyCode(String string) {
        String[] stringArray = string.split(";");
        return ACRCodeFactory.createPathologyInstance(stringArray[0], stringArray[1]);
    }

    private static ACRAnatomyNode createAnatomyNode(ACRCode aCRCode) {
        return new ACRAnatomyNode(aCRCode);
    }

    private static ACRPathologyNode createPathologyNode(ACRCode aCRCode, ACRAnatomyNode aCRAnatomyNode) {
        return new ACRPathologyNode(aCRCode, aCRAnatomyNode);
    }

    private static class ACRCodeComparator
    implements Comparator<ACRCode> {
        private ACRCodeComparator() {
        }

        @Override
        public int compare(ACRCode aCRCode, ACRCode aCRCode2) {
            try {
                return aCRCode.getId().compareTo(aCRCode2.getId());
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

