/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.clinicalcode.acr.code;

import com.agfa.pacs.listtext.clinicalcode.acr.ACRCode;
import com.agfa.pacs.listtext.clinicalcode.acr.code.CompositeACRCode;
import com.agfa.pacs.listtext.clinicalcode.acr.code.SimpleACRCode;
import com.agfa.pacs.listtext.clinicalcode.acr.data.ACRCodeRawData;

public class ACRCodeFactory {
    public static ACRCode createAnatomyInstance(String string, String string2) {
        return new SimpleACRCode(ACRCode.ACRCodeType.ANATOMY_CODE, string, string2);
    }

    public static ACRCode createPathologyInstance(String string, String string2) {
        return new SimpleACRCode(ACRCode.ACRCodeType.PATHOLOGY_CODE, string, string2);
    }

    public static ACRCode createCompositeInstance(ACRCode aCRCode, ACRCode aCRCode2) {
        return new CompositeACRCode(aCRCode, aCRCode2);
    }

    public static ACRCode createInstance(String string) {
        try {
            String[] stringArray = ACRCodeRawData.getRawDataAnatomy();
            if (CompositeACRCode.isCompositeId(string)) {
                String[] stringArray2 = CompositeACRCode.getSimpleIds(string);
                ACRCode aCRCode = ACRCodeFactory.createAnatomyInstance(stringArray2[0], ACRCodeFactory.findDescriptionForId(stringArray2[0], stringArray));
                ACRCode aCRCode2 = ACRCodeFactory.createPathologyInstance(stringArray2[1], ACRCodeFactory.findDescriptionForId(stringArray2[1], ACRCodeRawData.getRawDataPathology(Integer.parseInt(stringArray2[0].substring(0, 1)))));
                return ACRCodeFactory.createCompositeInstance(aCRCode, aCRCode2);
            }
            String string2 = ACRCodeFactory.findDescriptionForId(string, stringArray);
            if (string2 != null) {
                return ACRCodeFactory.createAnatomyInstance(string, string2);
            }
            int n = 0;
            while (n < 10 && string2 == null) {
                string2 = ACRCodeFactory.findDescriptionForId(string, ACRCodeRawData.getRawDataPathology(n));
                ++n;
            }
            return ACRCodeFactory.createPathologyInstance(string, string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String findDescriptionForId(String string, String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray2[n2];
            String[] stringArray3 = string2.split(";");
            if (string.equals(stringArray3[1])) {
                return stringArray3[0];
            }
            ++n2;
        }
        return null;
    }
}

