/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.progress.impl;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.busylabel.JXBusyLabel;
import com.agfa.pacs.base.swing.progress.impl.ActivityDisplay;
import com.agfa.pacs.base.swing.progress.impl.ProgressState;
import com.agfa.pacs.base.swing.util.GUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JProgressBar;

class ProgressDisplay
extends ActivityDisplay {
    private JProgressBar progressBar;

    public ProgressDisplay(IComponentFactory iComponentFactory, ProgressState progressState) {
        super(iComponentFactory, progressState != null ? progressState : new ProgressState());
    }

    public ProgressDisplay(IComponentFactory iComponentFactory) {
        this(iComponentFactory, null);
    }

    public ProgressState getProgressState() {
        return (ProgressState)this.getActivityState();
    }

    @Override
    protected void createComponents() {
        super.createComponents();
        this.progressBar = new JProgressBar(0, 0, 100);
    }

    @Override
    protected void installLayout() {
        if (this.exitBtn.getIcon() != null) {
            int n = this.exitBtn.getIcon().getIconWidth();
            Dimension dimension = new Dimension(n + 4, n + 4);
            this.exitBtn.setMaximumSize(dimension);
            this.exitBtn.setMinimumSize(dimension);
            this.exitBtn.setPreferredSize(dimension);
        }
        this.setBorder(this.displayBorder);
        this.setLayout(new BorderLayout());
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.exitBtn);
        this.exitBtn.setAlignmentX(1.0f);
        this.add((Component)box, "North");
        box = Box.createVerticalBox();
        box.add(this.textLabel);
        box.add(Box.createVerticalStrut(10));
        this.textLabel.setAlignmentX(0.5f);
        this.add((Component)box, "Center");
        box = Box.createVerticalBox();
        box.add(this.progressBar);
        this.progressBar.setAlignmentX(0.5f);
        this.add((Component)box, "South");
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.progressBar.setValue(this.getProgressIntValue());
    }

    @Override
    protected JXBusyLabel createBusyIconLabel() {
        Dimension dimension = GUI.getScaledDiagnosticDimension(32, 32);
        JXBusyLabel jXBusyLabel = new JXBusyLabel(dimension);
        return jXBusyLabel;
    }

    private int getProgressIntValue() {
        ProgressState progressState = (ProgressState)this.getActivityState();
        return Math.round(progressState.getProgress() * 100.0f);
    }
}

