/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.progress.impl;

import com.agfa.pacs.base.swing.progress.impl.ActivityDisplay;
import com.agfa.pacs.base.swing.progress.impl.ActivityDisplayContainerListener;
import com.agfa.pacs.base.swing.progress.impl.IActivityDisplayContainer;
import com.agfa.pacs.base.swing.util.EventUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

class DialogActivityDisplayContainer
implements IActivityDisplayContainer {
    private JRootPane rootPane;
    private Component client;
    private List<ActivityDisplay> displays;
    private Map<ActivityDisplay, JDialog> displaysToDlgs;
    private Collection<ActivityDisplayContainerListener> listener;
    private ResizeListener resizeListener;
    private final DialogListener dialogListener;

    protected DialogActivityDisplayContainer(Component component) {
        assert (component != null) : "client component is null!";
        this.client = component;
        this.rootPane = SwingUtilities.getRootPane(component);
        this.displays = new ArrayList<ActivityDisplay>();
        this.displaysToDlgs = new HashMap<ActivityDisplay, JDialog>();
        this.resizeListener = new ResizeListener();
        this.dialogListener = new DialogListener();
        this.listener = new ArrayList<ActivityDisplayContainerListener>();
        this.installListeners();
    }

    @Override
    public int getActivityDisplayCount() {
        return this.displays.size();
    }

    @Override
    public ActivityDisplay getActivityDisplay(int n) throws IllegalArgumentException {
        return this.displays.get(n);
    }

    @Override
    public Iterable<ActivityDisplay> getActivityDisplays() {
        return this.displays;
    }

    @Override
    public Component getClient() {
        return this.client;
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    @Override
    public synchronized void addActivityDisplays(Collection<ActivityDisplay> collection) {
        assert (collection != null) : "param displays is null!";
        if (!collection.isEmpty()) {
            this.displays.addAll(collection);
            for (ActivityDisplay activityDisplay : collection) {
                activityDisplay.setActivityDisplayContainer(this);
                this.displaysToDlgs.put(activityDisplay, this.createDialogForDisplay(activityDisplay));
            }
            this.updateContainer();
            for (ActivityDisplay activityDisplay : collection) {
                this.fireActivityDisplayAdded(activityDisplay);
            }
        }
    }

    @Override
    public synchronized void removeActivityDisplays(Collection<ActivityDisplay> collection) {
        assert (collection != null) : "param displays is null!";
        if (!this.displays.isEmpty()) {
            ArrayList<ActivityDisplay> arrayList = new ArrayList<ActivityDisplay>();
            for (ActivityDisplay activityDisplay : collection) {
                if (!this.displays.contains(activityDisplay)) continue;
                activityDisplay.setActivityDisplayContainer(null);
                arrayList.add(activityDisplay);
            }
            this.displays.removeAll(arrayList);
            this.updateContainer();
            for (ActivityDisplay activityDisplay : arrayList) {
                this.fireActivityDisplayRemoved(activityDisplay);
            }
        }
    }

    @Override
    public void addActivityDisplayContainerListener(ActivityDisplayContainerListener activityDisplayContainerListener) {
        if (activityDisplayContainerListener != null && !this.listener.contains(activityDisplayContainerListener)) {
            this.listener.add(activityDisplayContainerListener);
        }
    }

    @Override
    public void removeActivityDisplayContainerListener(ActivityDisplayContainerListener activityDisplayContainerListener) {
        if (activityDisplayContainerListener != null && this.listener.contains(activityDisplayContainerListener)) {
            this.listener.remove(activityDisplayContainerListener);
        }
    }

    protected void finalize() throws Throwable {
        this.uninstallListeners();
        super.finalize();
    }

    protected void installListeners() {
        Window window = SwingUtilities.windowForComponent(this.client);
        this.client.addComponentListener(this.resizeListener);
        if (window != null) {
            window.addComponentListener(this.resizeListener);
        }
    }

    protected void uninstallListeners() {
        Window window = SwingUtilities.windowForComponent(this.client);
        this.client.removeComponentListener(this.resizeListener);
        if (window != null) {
            window.removeComponentListener(this.resizeListener);
        }
    }

    protected void updateContainer() {
        try {
            EventUtil.invokeSynchronous(new Runnable(){

                @Override
                public void run() {
                    Container container;
                    ArrayList<Container> arrayList = new ArrayList<Container>();
                    for (Map.Entry object : DialogActivityDisplayContainer.this.displaysToDlgs.entrySet()) {
                        container = (ActivityDisplay)object.getKey();
                        JDialog jDialog = (JDialog)object.getValue();
                        if (DialogActivityDisplayContainer.this.displays.contains(container)) {
                            DialogActivityDisplayContainer.this.updateLocationAndSize((ActivityDisplay)container);
                            jDialog.setVisible(true);
                            continue;
                        }
                        arrayList.add(container);
                        jDialog.setVisible(false);
                        jDialog.dispose();
                    }
                    for (ActivityDisplay activityDisplay : arrayList) {
                        container = (JDialog)DialogActivityDisplayContainer.this.displaysToDlgs.remove(activityDisplay);
                        container.removeComponentListener(DialogActivityDisplayContainer.this.dialogListener);
                    }
                }
            });
        }
        catch (Exception exception) {}
    }

    protected JDialog createDialogForDisplay(ActivityDisplay activityDisplay) {
        assert (activityDisplay != null) : "Activity Display is null!";
        JDialog jDialog = new JDialog(JOptionPane.getFrameForComponent(this.client), false);
        jDialog.setResizable(false);
        jDialog.setUndecorated(true);
        jDialog.getContentPane().setLayout(new BorderLayout());
        jDialog.getContentPane().add((Component)activityDisplay, "Center");
        jDialog.addComponentListener(this.dialogListener);
        return jDialog;
    }

    void updateDisplayLocationsAndSize() {
        for (ActivityDisplay activityDisplay : this.displays) {
            this.updateLocationAndSize(activityDisplay);
        }
    }

    void updateDisplayVisibility(boolean bl) {
        for (ActivityDisplay activityDisplay : this.displays) {
            this.updateVisibility(activityDisplay, bl);
        }
    }

    private void updateLocationAndSize(ActivityDisplay activityDisplay) {
        JDialog jDialog = this.displaysToDlgs.get(activityDisplay);
        int n = this.displays.size();
        int n2 = this.displays.indexOf(activityDisplay);
        Rectangle rectangle = this.client.getBounds();
        int n3 = jDialog.getPreferredSize().width;
        int n4 = jDialog.getPreferredSize().height;
        int n5 = rectangle.width / n;
        int n6 = rectangle.y + rectangle.height / 2 - n4 / 2;
        int n7 = rectangle.x + n2 * n5 + n5 / 2 - n3 / 2;
        Point point = SwingUtilities.convertPoint(this.client.getParent(), n7, n6, jDialog.getOwner());
        point.x += jDialog.getOwner().getLocation().x;
        point.y += jDialog.getOwner().getLocation().y;
        jDialog.setBounds(point.x, point.y, n3, n4);
        jDialog.invalidate();
        jDialog.validate();
        jDialog.repaint();
    }

    private void updateVisibility(ActivityDisplay activityDisplay, boolean bl) {
        JDialog jDialog = this.displaysToDlgs.get(activityDisplay);
        jDialog.setVisible(bl);
    }

    private void fireActivityDisplayAdded(ActivityDisplay activityDisplay) {
        for (ActivityDisplayContainerListener activityDisplayContainerListener : this.listener) {
            activityDisplayContainerListener.activityDisplayAdded(this, activityDisplay);
        }
    }

    private void fireActivityDisplayRemoved(ActivityDisplay activityDisplay) {
        ArrayList<ActivityDisplayContainerListener> arrayList = new ArrayList<ActivityDisplayContainerListener>(this.listener);
        for (ActivityDisplayContainerListener activityDisplayContainerListener : arrayList) {
            activityDisplayContainerListener.activityDisplayRemoved(this, activityDisplay);
        }
    }

    private class DialogListener
    extends ComponentAdapter {
        private DialogListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            DialogActivityDisplayContainer.this.updateDisplayLocationsAndSize();
        }
    }

    private class ResizeListener
    extends ComponentAdapter {
        private ResizeListener() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            DialogActivityDisplayContainer.this.updateDisplayLocationsAndSize();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            DialogActivityDisplayContainer.this.updateDisplayLocationsAndSize();
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            DialogActivityDisplayContainer.this.updateDisplayVisibility(true);
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            DialogActivityDisplayContainer.this.updateDisplayVisibility(false);
        }
    }
}

