/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.progress.impl;

import com.agfa.pacs.base.swing.progress.impl.ActivityStateListener;
import com.agfa.pacs.data.shared.JobState;
import java.util.Collection;
import java.util.Vector;

class ActivityState {
    private JobState state;
    private String text;
    private Collection<ActivityStateListener> listener = new Vector<ActivityStateListener>();

    public ActivityState(JobState jobState, String string) {
        this.state = jobState != null ? jobState : JobState.STARTED;
        this.text = string;
    }

    public ActivityState(String string) {
        this(null, string);
    }

    public ActivityState() {
        this(null);
    }

    public JobState getState() {
        return this.state;
    }

    public synchronized void setState(JobState jobState) {
        if (jobState != null && !jobState.equals((Object)this.state)) {
            this.state = jobState;
            this.fireStateChanged();
        }
    }

    public String getText() {
        return this.text;
    }

    public synchronized void setText(String string) {
        boolean bl;
        boolean bl2 = bl = this.text == null && string != null;
        if (!bl && string != null) {
            boolean bl3 = bl = !string.equals(this.text);
        }
        if (bl) {
            this.text = string;
            this.fireStateChanged();
        }
    }

    public void addActivityStateListener(ActivityStateListener activityStateListener) {
        if (activityStateListener != null && !this.listener.contains(activityStateListener)) {
            this.listener.add(activityStateListener);
        }
    }

    public void removeActivityStateListener(ActivityStateListener activityStateListener) {
        if (activityStateListener != null && this.listener.contains(activityStateListener)) {
            this.listener.remove(activityStateListener);
        }
    }

    protected void fireStateChanged() {
        for (ActivityStateListener activityStateListener : this.listener) {
            activityStateListener.activityStateChanged(this);
        }
    }
}

