/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.listsearch;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.Messages;
import com.agfa.pacs.base.swing.listsearch.ListSearchEngine;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ListSearchPanel
extends JPanel {
    private ListSearchEngine searchEngine;

    public ListSearchPanel(ListModel listModel, ListSelectionModel listSelectionModel, boolean bl, IComponentFactory iComponentFactory) {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        this.searchEngine = new ListSearchEngine(listModel, listSelectionModel, bl);
        final JTextField jTextField = iComponentFactory.createTextField();
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
        this.add(iComponentFactory.createLabel(String.valueOf(Messages.getString("ListSearchPanel.Search")) + ": "));
        gridBagConstraints = new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
        jTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                ListSearchPanel.this.searchEngine.setSearchString(jTextField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                ListSearchPanel.this.searchEngine.setSearchString(jTextField.getText());
            }
        });
        this.add((Component)jTextField, gridBagConstraints);
        Action[] actionArray = this.searchEngine.getActions();
        int n = 0;
        while (n < actionArray.length) {
            gridBagConstraints = new GridBagConstraints(n + 2, 0, 1, 0, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
            this.add((Component)iComponentFactory.createButton(actionArray[n]), gridBagConstraints);
            ++n;
        }
    }

    public void setListModel(ListModel listModel) {
        this.searchEngine.setListModel(listModel);
    }
}

