/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.imagednd;

import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.logging.ALogger;
import com.sun.awt.AWTUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class ImageDragAndDropManager {
    private static final String CONFIG_PATH = "imageDragAndDrop";
    private static final ALogger log = ALogger.getLogger(ImageDragAndDropManager.class);
    private static ImageDragAndDropManager instance;
    private DragSource currentSource;
    private GhostedDragImage currentImage;
    private ImageDragSourceListener listener = new ImageDragSourceListener();

    private ImageDragAndDropManager() {
    }

    public static synchronized ImageDragAndDropManager getInstance() {
        if (instance == null) {
            instance = new ImageDragAndDropManager();
        }
        return instance;
    }

    public void startImageDragAndDrop(DragSource dragSource, BufferedImage bufferedImage) {
        this.startImageDragAndDrop(dragSource, bufferedImage, 1.0f);
    }

    public void startImageDragAndDrop(DragSource dragSource, BufferedImage bufferedImage, float f) {
        if (bufferedImage == null || dragSource == null || !this.isEnabled()) {
            return;
        }
        Point point = MouseInfo.getPointerInfo().getLocation();
        this.startImageDragAndDrop(dragSource, point, bufferedImage, f);
    }

    private boolean isEnabled() {
        try {
            return ConfigurationProviderFactory.getConfig().getBoolean(CONFIG_PATH);
        }
        catch (Exception exception) {
            log.error("Reading image drag&drop enable/disable state failed! Disabling image drag&drop...", (Throwable)exception);
            return false;
        }
    }

    private void startImageDragAndDrop(DragSource dragSource, Point point, Image image, float f) {
        Window window;
        if (this.currentImage != null) {
            this.stopImageDragAndDrop();
        }
        if (image != null && (window = this.findWindow(point)) != null) {
            this.currentImage = new GhostedDragImage(window, new ImageIcon(image), f, point, new Point(GUI.getScaledInt(25), GUI.getScaledInt(15)));
            this.currentSource = dragSource;
            this.currentSource.addDragSourceListener(this.listener);
            this.currentSource.addDragSourceMotionListener(this.listener);
        }
    }

    private void stopImageDragAndDrop() {
        if (this.currentSource != null) {
            this.currentSource.removeDragSourceListener(this.listener);
            this.currentSource.removeDragSourceMotionListener(this.listener);
        }
        if (this.currentImage != null) {
            this.currentImage.dispose();
        }
        this.currentSource = null;
        this.currentImage = null;
    }

    private Window findWindow(Point point) {
        Window[] windowArray = Window.getWindows();
        if (windowArray != null) {
            Window[] windowArray2 = windowArray;
            int n = windowArray.length;
            int n2 = 0;
            while (n2 < n) {
                Window window = windowArray2[n2];
                Point point2 = (Point)point.clone();
                SwingUtilities.convertPointFromScreen(point2, window);
                if (window.contains(point2) && window.isFocused()) {
                    return this.findTopMostWindow(window);
                }
                ++n2;
            }
        }
        return null;
    }

    private Window findTopMostWindow(Window window) {
        Window window2 = window;
        while (window2.getOwner() != null) {
            window2 = window2.getOwner();
        }
        return window2;
    }

    private static class GhostedDragImage {
        private static final int SLIDE_INTERVAL = 33;
        private Window window;
        private Point origin;
        private Point offset;

        public GhostedDragImage(Component component, final Icon icon, float f, Point point, Point point2) {
            Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            this.offset = point2;
            this.window = new Window(window, window.getGraphicsConfiguration()){

                @Override
                public void paint(Graphics graphics) {
                    icon.paintIcon(this, graphics, 0, 0);
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(icon.getIconWidth(), icon.getIconHeight());
                }

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            this.window.setFocusableWindowState(true);
            this.window.pack();
            AWTUtilities.setWindowOpacity((Window)this.window, (float)f);
            this.move(point);
            this.window.setVisible(true);
            this.window.toFront();
            this.window.repaint();
        }

        public void setAlpha(float f) {
            AWTUtilities.setWindowOpacity((Window)this.window, (float)f);
        }

        public void dispose() {
            this.window.dispose();
            this.window = null;
        }

        public void move(Point point) {
            if (this.origin == null) {
                this.origin = point;
            }
            if (this.offset == null) {
                this.window.setLocation(point.x, point.y);
            } else {
                this.window.setLocation(point.x + this.offset.x, point.y + this.offset.y);
            }
        }

        public void returnToOrigin() {
            final Timer timer = new Timer(33, null);
            timer.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Point point = GhostedDragImage.this.window.getLocationOnScreen();
                    Point point2 = new Point(GhostedDragImage.this.origin);
                    int n = (point2.x - point.x) / 2;
                    int n2 = (point2.y - point.y) / 2;
                    if (n != 0 || n2 != 0) {
                        point.translate(n, n2);
                        GhostedDragImage.this.move(point);
                    } else {
                        timer.stop();
                        GhostedDragImage.this.dispose();
                    }
                }
            });
            timer.setInitialDelay(0);
            timer.start();
        }
    }

    private class ImageDragSourceListener
    extends DragSourceAdapter {
        private ImageDragSourceListener() {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            ImageDragAndDropManager.this.stopImageDragAndDrop();
        }

        @Override
        public void dragMouseMoved(DragSourceDragEvent dragSourceDragEvent) {
            if (ImageDragAndDropManager.this.currentImage != null) {
                ImageDragAndDropManager.this.currentImage.move(dragSourceDragEvent.getLocation());
            }
        }
    }
}

