/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.config.provider.internal;

import com.agfa.pacs.config.ConfigType;
import com.agfa.pacs.config.IConfigurationChangeListener;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.config.provider.internal.ConfigIntermediateNode;
import com.agfa.pacs.config.provider.internal.ConfigLeafNode;
import com.agfa.pacs.config.provider.internal.ConfigListNode;
import com.agfa.pacs.config.provider.internal.ConfigNode;
import com.agfa.pacs.config.provider.internal.ConfigTree;
import com.agfa.pacs.config.provider.internal.ConfigTreeList;
import com.agfa.pacs.config.provider.internal.StringSplit;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class VirtualConfigTree
implements IConfigurationProvider {
    private ConfigTreeList parent;
    private String itemID;
    private ConfigTree master;
    private String prefix;
    private int index;
    private ConfigTree realTree;

    protected VirtualConfigTree(ConfigTreeList configTreeList, ConfigTree configTree, String string) {
        this(configTreeList, configTree, string, Integer.toString(ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE)));
    }

    protected VirtualConfigTree(ConfigTreeList configTreeList, ConfigTree configTree, String string, String string2) {
        this.parent = configTreeList;
        this.itemID = string2;
        this.master = configTree;
        this.prefix = string;
        this.index = -1;
    }

    protected VirtualConfigTree(ConfigTreeList configTreeList, ConfigTree configTree, String string, int n) {
        this(configTreeList, configTree, string);
        this.index = n;
    }

    private synchronized void devirtualize(String string, ConfigType configType) {
        if (this.realTree != null) {
            return;
        }
        ConfigNode configNode = string.length() == 0 ? (ConfigType.List == configType ? new ConfigListNode() : new ConfigLeafNode(configType)) : new ConfigIntermediateNode();
        this.parent.appendDevirtualizedNode(configNode, this.itemID, this.index);
        this.realTree = this.master.clone(configNode, String.valueOf(this.prefix) + '#' + this.itemID);
    }

    public String getId() {
        return this.itemID;
    }

    public String getString(String string) throws IllegalArgumentException {
        this.devirtualize(string, ConfigType.String);
        return this.realTree.getString(string);
    }

    public boolean exists(String string) {
        if (this.realTree == null) {
            return false;
        }
        return this.realTree.exists(string);
    }

    public void setString(String string, String string2) throws IllegalArgumentException {
        this.devirtualize(string, ConfigType.String);
        this.realTree.setString(string, string2);
    }

    public void removeValue(String string) throws IllegalArgumentException {
        if (this.realTree == null) {
            return;
        }
        this.realTree.removeValue(string);
    }

    public IConfigurationProvider getNode(String string) {
        this.devirtualize(string, null);
        return this.realTree.getNode(string);
    }

    public IConfigurationList getList(String string) {
        this.devirtualize(string, ConfigType.List);
        return this.realTree.getList(string);
    }

    public double getDouble(String string) throws IllegalArgumentException {
        this.devirtualize(string, ConfigType.Double);
        return this.realTree.getDouble(string);
    }

    public long getLong(String string) throws IllegalArgumentException {
        this.devirtualize(string, ConfigType.Long);
        return this.realTree.getLong(string);
    }

    public boolean getBoolean(String string) throws IllegalArgumentException {
        this.devirtualize(string, ConfigType.Boolean);
        return this.realTree.getBoolean(string);
    }

    public void setDouble(String string, double d) throws IllegalArgumentException {
        this.devirtualize(string, ConfigType.Double);
        this.realTree.setDouble(string, d);
    }

    public void setLong(String string, long l) throws IllegalArgumentException {
        this.devirtualize(string, ConfigType.Long);
        this.realTree.setLong(string, l);
    }

    public void setBoolean(String string, boolean bl) throws IllegalArgumentException {
        this.devirtualize(string, ConfigType.Boolean);
        this.realTree.setBoolean(string, bl);
    }

    public void registerConfigurationChangeListener(String string, IConfigurationChangeListener iConfigurationChangeListener) {
        throw new UnsupportedOperationException();
    }

    public void deregisterConfigurationChangeListener(String string, IConfigurationChangeListener iConfigurationChangeListener) {
        throw new UnsupportedOperationException();
    }

    public IConfigurationList createList(String string) {
        String[] stringArray = StringSplit.split(string, '.');
        if (stringArray.length > 1) {
            this.devirtualize(string, null);
            return this.realTree.createList(string);
        }
        this.devirtualize(string, ConfigType.List);
        return this.realTree.createList(string);
    }

    public void setRole(String string) {
    }

    public String getRole() {
        return this.master.getRole();
    }

    public String toString() {
        return "Node:" + this.prefix;
    }

    public String getText(String string) throws IllegalArgumentException {
        this.devirtualize(string, ConfigType.Text);
        return this.realTree.getString(string);
    }

    public void setText(String string, String string2) throws IllegalArgumentException {
        this.devirtualize(string, ConfigType.Text);
        this.realTree.setText(string, string2);
    }

    public boolean isSupportingRoles() {
        return this.master.isSupportingRoles();
    }

    public IConfigurationProvider clone(String string) {
        throw new UnsupportedOperationException("Not supported");
    }

    public String getType(String string) throws IllegalArgumentException {
        if (this.realTree == null) {
            throw new IllegalArgumentException("Not supported for virtual truees");
        }
        return this.realTree.getType(string);
    }

    public void storeAllConfiguration() {
    }

    public void updateCache(String string) {
    }

    public void storeConfigurationForRole(String string) {
        throw new UnsupportedOperationException("Not allowed");
    }

    public Map<String, String> getValuesWithLocalizedStrings(String string) {
        this.devirtualize(string, ConfigType.String);
        return this.realTree.getValuesWithLocalizedStrings(string);
    }

    public String getRole(String string) {
        if (this.realTree == null) {
            throw new IllegalArgumentException("Not supported for virtual truees");
        }
        return this.realTree.getRole(string);
    }
}

