/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.listtext.lta.util.referencedobject.IReferencedObjectProvider;
import java.util.List;

public abstract class ReferencedObjectProviderFactory {
    private static ReferencedObjectProviderFactory implementation;

    public static synchronized ReferencedObjectProviderFactory getInstance() {
        if (implementation == null) {
            ReferencedObjectProviderFactory.initialize();
        }
        return implementation;
    }

    public List<IReferencedObjectProvider> getReferencedObjectProviders() {
        return this.getReferencedObjectProvidersImpl();
    }

    public IReferencedObjectProvider getSupportedReferencedObjectProvider(IDataInfoSource iDataInfoSource) {
        for (IReferencedObjectProvider iReferencedObjectProvider : this.getReferencedObjectProviders()) {
            if (!iReferencedObjectProvider.supportsSource(iDataInfoSource)) continue;
            return iReferencedObjectProvider;
        }
        return null;
    }

    protected abstract List<IReferencedObjectProvider> getReferencedObjectProvidersImpl();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)ReferencedObjectProviderFactory.class.getName()));
            implementation = (ReferencedObjectProviderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + ReferencedObjectProviderFactory.class.getName(), reflectiveOperationException);
        }
    }
}

