/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.referencedobject;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.data.dicom.comm.DicomCFindConst;
import com.agfa.pacs.data.dicom.config.DicomConfigurationFactory;
import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.lw.DataInfoFactoryProvider;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.ISeriesInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSeries;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedWaveform;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import com.agfa.pacs.listtext.dicomobject.sr.content.Content;
import com.agfa.pacs.listtext.dicomobject.sr.content.ContentTemplate;
import com.agfa.pacs.listtext.dicomobject.sr.content.DocumentContent;
import com.agfa.pacs.listtext.dicomobject.sr.content.SRReferencedImage;
import com.agfa.pacs.listtext.dicomobject.type.ContinuityOfContent;
import com.agfa.pacs.listtext.dicomobject.type.RelationshipType;
import com.agfa.pacs.listtext.dicomobject.type.ValueType;
import com.agfa.pacs.listtext.lta.util.Modality;
import com.agfa.pacs.listtext.lta.util.referencedobject.ReferringObjectType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.UIDUtils;

public class KeyObjectAttributes
implements DatasetSource {
    private static final ContentTemplate KEY_OBJECT_CONTENT_TEMPLATE = new ContentTemplate("2010", "DCMR");
    private final ISeriesInfo seriesInfo;
    private final Attributes attributes;
    private final Sequence contentSequence;
    private final List<SOPInstanceReference> studyReferences;
    private IObjectInfo objectInfo;
    private ReferringObjectType koType;
    private String retrieveAET;

    public KeyObjectAttributes(ReferringObjectType referringObjectType, IStudyInfo iStudyInfo) {
        this.koType = referringObjectType;
        this.seriesInfo = iStudyInfo.createSeries(Modality.KO.dicom());
        this.attributes = KeyObjectAttributes.initAttributes(referringObjectType, this.seriesInfo);
        this.retrieveAET = this.attributes.getString(524372);
        this.attributes.remove(524372);
        this.contentSequence = this.attributes.newSequence(4237104, 10);
        this.studyReferences = new ArrayList<SOPInstanceReference>(1);
    }

    private static Attributes initAttributes(ReferringObjectType referringObjectType, ISeriesInfo iSeriesInfo) {
        if (referringObjectType == ReferringObjectType.FOR_XDS) {
            referringObjectType = ReferringObjectType.OF_INTEREST;
        }
        iSeriesInfo.getAttributes().setString(528446, VR.LO, "Flag [" + referringObjectType.getDicomCode().getCodeMeaning() + ']');
        Attributes attributes = new Attributes();
        Date date = new Date();
        attributes.addSelected(iSeriesInfo.getDicomObjectMerged(), DicomCFindConst.SERIES_MERGED_TAGS);
        attributes.setString(524293, VR.CS, DicomConfigurationFactory.getConfiguration().getDefaultCharacterSet());
        attributes.setString(524310, VR.UI, "1.2.840.10008.5.1.4.1.1.88.59");
        attributes.setString(524312, VR.UI, UIDUtils.createUID());
        attributes.setDate(2251877123620883L, date);
        attributes.setInt(2097171, VR.IS, new int[]{1});
        attributes.setDate(2251950138064947L, date);
        attributes.setNull(528657, VR.SQ);
        attributes.setString(524400, VR.LO, Product.getProductVendor());
        attributes.setString(528528, VR.LO, Product.getProductName());
        attributes.setString(1576992, VR.LO, Product.getVersionString());
        attributes.setString(0x40A040, VR.CS, ValueType.Container.dicom());
        Sequence sequence = attributes.newSequence(4235331, 1);
        sequence.add(referringObjectType.getDicomCode().toDataset());
        attributes.setString(4235344, VR.CS, ContinuityOfContent.Separate.dicom());
        Sequence sequence2 = attributes.newSequence(4236548, 1);
        sequence2.add(KEY_OBJECT_CONTENT_TEMPLATE.toDataset());
        return attributes;
    }

    public Attributes toDataset() {
        Attributes attributes = new Attributes(this.attributes);
        Sequence sequence = attributes.newSequence(4236149, this.studyReferences.size());
        for (SOPInstanceReference sOPInstanceReference : this.studyReferences) {
            sequence.add(sOPInstanceReference.toDataset());
        }
        return attributes;
    }

    public synchronized IObjectInfo toObjectInfo() {
        if (this.objectInfo == null) {
            Attributes attributes = this.toDataset();
            this.objectInfo = DataInfoFactoryProvider.getInstance().createObjectInfo(this.seriesInfo, attributes, attributes.getString(524312));
            this.seriesInfo.addChild((IDataInfo)this.objectInfo);
        }
        return this.objectInfo;
    }

    public void insertReference(String string, String string2, String string3, String string4, int[] nArray) {
        if (this.objectInfo != null) {
            throw new IllegalStateException("Object info already created, no more modification allowed.");
        }
        this.addToContentSequence(string, string2, nArray);
        this.addToStudyReferences(string, string2, string3, string4);
    }

    private void addToContentSequence(String string, String string2, int[] nArray) {
        DocumentContent.CompositeContent compositeContent;
        switch (UIDUtilities.getBaseType((String)string)) {
            case Image: {
                compositeContent = new DocumentContent.ImageContent(new SRReferencedImage(string, string2, nArray));
                break;
            }
            case Waveform: {
                compositeContent = new DocumentContent.WaveformContent(new ReferencedWaveform(string, string2, nArray));
                break;
            }
            case Presentation: 
            case StructuredReport: 
            case KeyObject: 
            case Composite: {
                compositeContent = new DocumentContent.CompositeContent(new ReferencedSOP(string, string2));
                break;
            }
            default: {
                return;
            }
        }
        this.contentSequence.add(new Content(RelationshipType.Contains, (DocumentContent)compositeContent, null).toDataset());
    }

    private void addToStudyReferences(String string, String string2, String string3, String string4) {
        SOPInstanceReference sOPInstanceReference3;
        SOPInstanceReference sOPInstanceReference2 = null;
        for (SOPInstanceReference sOPInstanceReference3 : this.studyReferences) {
            if (!sOPInstanceReference3.getStudyInstanceUID().equals(string4)) continue;
            sOPInstanceReference2 = sOPInstanceReference3;
            break;
        }
        if (sOPInstanceReference2 == null) {
            sOPInstanceReference2 = new SOPInstanceReference(string4);
            this.studyReferences.add(sOPInstanceReference2);
        }
        sOPInstanceReference3 = null;
        for (ReferencedSeries referencedSeries : sOPInstanceReference2.referencedSeries()) {
            if (!referencedSeries.getSeriesInstanceUID().equals(string3)) continue;
            sOPInstanceReference3 = referencedSeries;
            break;
        }
        if (sOPInstanceReference3 == null) {
            sOPInstanceReference3 = new ReferencedSeries(string3);
            if (this.retrieveAET != null && this.koType == ReferringObjectType.FOR_XDS) {
                sOPInstanceReference3.setRetrieveAETs(new String[]{this.retrieveAET});
            }
            sOPInstanceReference2.referencedSeries().add(sOPInstanceReference3);
        }
        sOPInstanceReference3.referencedSOP().add(new ReferencedSOP(string, string2));
    }
}

