/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util.job;

import com.agfa.pacs.background.IBackgroundProgress;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.base.util.DicomUtils;
import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IPatientInfo;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.integration.Messages;
import com.agfa.pacs.listtext.lta.progress.ProgressStateModel;
import java.util.List;
import java.util.Vector;
import org.dcm4che3.data.Attributes;

public class JobControl
implements Runnable,
IBackgroundProgress,
Cancelable {
    private int tasks = 0;
    private int active = -1;
    private ProgressStateModel model;
    private Vector<IBackgroundTask> list = new Vector();

    public JobControl(String string, String string2) {
        this.model = new ProgressStateModel();
        this.model.addCancelable(this);
        this.model.setProgressTitle(string);
        this.model.setDetailedMessage(string2);
    }

    public synchronized boolean addTask(IBackgroundTask iBackgroundTask) {
        if (this.model == null) {
            return false;
        }
        this.list.add(iBackgroundTask);
        iBackgroundTask.take((IBackgroundProgress)this);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.model.setState(JobState.STARTED);
        this.model.setState(JobState.PROGRESSING);
        this.tasks = this.list.size();
        this.active = 0;
        while (this.active < this.tasks) {
            if (this.model.isCanceled()) break;
            IBackgroundTask iBackgroundTask = this.list.elementAt(this.active);
            boolean bl = iBackgroundTask.execute();
            if (!bl) {
                this.model.setState(JobState.FAILED);
                break;
            }
            ++this.active;
        }
        if (!this.model.isCanceled() && this.model.getProgressState() != JobState.FAILED) {
            this.model.setState(JobState.FINISHED);
        }
        JobControl jobControl = this;
        synchronized (jobControl) {
            this.list.clear();
            this.model = null;
        }
    }

    public void progress(double d) {
        this.setProgress((float)d);
    }

    public void setProgress(float f) {
        float f2 = this.active;
        float f3 = this.tasks;
        this.model.setProgress(f2 / f3 + f / f3);
    }

    public void progress(double d, String string) {
        this.model.setProgress((float)d);
        if (string != null) {
            this.model.setStateMessage(string);
        }
    }

    public ProgressStateModel getModel() {
        return this.model;
    }

    public void cancel() {
        if (this.active >= 0 && this.active < this.list.size()) {
            this.list.elementAt(this.active).terminate();
        }
    }

    public boolean isRunning() {
        return this.model.getProgressState() == JobState.STARTED || this.model.getProgressState() == JobState.PROGRESSING;
    }

    public static String createDetailedInformation(String string, String string2, List<? extends IDataInfo> list) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        stringBuilder.append(string).append(Messages.getString("JobControl.TO_AS_DIRECTION")).append(string2);
        JobControl.appendDetailedInformation(stringBuilder, list);
        return stringBuilder.toString();
    }

    public static String createDetailedInformation(String string, List<? extends IDataInfo> list) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        stringBuilder.append(string);
        JobControl.appendDetailedInformation(stringBuilder, list);
        return stringBuilder.toString();
    }

    private static void appendDetailedInformation(StringBuilder stringBuilder, List<? extends IDataInfo> list) {
        stringBuilder.append("<ul>");
        for (IPatientInfo iPatientInfo : DataInfoUtilities.getLevel(list, IPatientInfo.class)) {
            stringBuilder.append("<li>").append(DicomUtils.getString((Attributes)iPatientInfo.getAttributes(), (int)0x100010)).append("</li>");
        }
        stringBuilder.append("</ul>");
    }

    public static String createDetailedInformation(String string, String string2, Attributes attributes) {
        StringBuilder stringBuilder = new StringBuilder("<html>");
        stringBuilder.append(string).append(Messages.getString("JobControl.TO_AS_DIRECTION")).append(string2).append("<ul>");
        stringBuilder.append("<li>").append(DicomUtils.getString((Attributes)attributes, (int)0x100010)).append("</li>");
        stringBuilder.append("</ul>");
        return stringBuilder.toString();
    }
}

