/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.integration.IScriptHelperCreator;
import com.agfa.pacs.listtext.lta.util.TestScriptUtil;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.FileUtil;
import com.agfa.pacs.tools.StreamReader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.swing.JRootPane;

public class TestScriptHelper
implements IScriptHelperCreator {
    private static final ALogger log = ALogger.getLogger(TestScriptHelper.class);

    public Object createHelper() {
        return this;
    }

    public Process exec(String string, File file) {
        try {
            Process process = Runtime.getRuntime().exec(string, null, file);
            new StreamReader(process.getInputStream(), true).start();
            return process;
        }
        catch (IOException iOException) {
            log.error("Executing command '" + string + "' failed.", (Throwable)iOException);
            return null;
        }
    }

    public int executeAndWait(String string, File file) {
        Process process = this.exec(string, file);
        if (process != null) {
            try {
                return process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                log.debug("Waiting for process end interrupted.", (Throwable)interruptedException);
            }
        }
        return -1;
    }

    public void recreateDirectory(String string) {
        File file = new File(string);
        if (file.exists()) {
            FileUtil.remove((File)file);
        }
        file.mkdirs();
    }

    public String[] readUIDs(String string) {
        File file = new File(string);
        if (!file.exists()) {
            log.warn("File:" + string + " does not exists");
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2;
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("#") || (string2 = string2.trim()).length() == 0) continue;
                arrayList.add(string2);
            }
            bufferedReader.close();
            inputStreamReader.close();
            return arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IOException iOException) {
            log.error("IO Error", (Throwable)iOException);
            return new String[0];
        }
    }

    public boolean compareImages(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        return TestScriptUtil.compareImagesInt(bufferedImage, bufferedImage2, null, null, 0);
    }

    public void writeImage(BufferedImage bufferedImage, String string) {
        TestScriptUtil.writeImage(bufferedImage, string);
    }

    public BufferedImage readImage(String string) {
        return TestScriptUtil.readImage(string);
    }

    public boolean writeImageDifference(BufferedImage bufferedImage, BufferedImage bufferedImage2, String string) {
        return TestScriptUtil.writeImageDifference(bufferedImage, null, bufferedImage2, string, 0);
    }

    public BufferedImage createImageOfComponent(String string) {
        Window[] windowArray = Window.getWindows();
        if (windowArray != null) {
            Object object;
            Component component = null;
            Window[] windowArray2 = windowArray;
            int n = windowArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = windowArray2[n2];
                component = this.findComponentByName((Component)object, string);
                if (component != null) break;
                ++n2;
            }
            if (component != null) {
                object = new BufferedImage(component.getWidth(), component.getHeight(), 1);
                component.paint(((BufferedImage)object).getGraphics());
                return object;
            }
        }
        return null;
    }

    public Component findComponentByName(Component component, String string) {
        if (string.equals(component.getName())) {
            return component;
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component component2 = componentArray[n2];
                Component component3 = null;
                if (string.equals(component2.getName())) {
                    component3 = component2;
                } else if (component2 instanceof JRootPane) {
                    component3 = this.findComponentByName(((JRootPane)component2).getContentPane(), string);
                } else if (component2 instanceof Container) {
                    component3 = this.findComponentByName(component2, string);
                }
                if (component3 != null) {
                    return component3;
                }
                ++n2;
            }
        }
        return null;
    }
}

