/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.util;

import com.agfa.pacs.data.shared.dicom.Level;
import com.agfa.pacs.data.shared.lw.DataInfoUtilities;
import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IRootInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.data.shared.util.Cancelable;
import com.agfa.pacs.listtext.dicomobject.general.ReferencedSOP;
import com.agfa.pacs.listtext.dicomobject.general.SOPInstanceReference;
import com.agfa.pacs.listtext.lta.datafinder.DataFinderFactory;
import com.agfa.pacs.listtext.lta.datafinder.IDataFinder;
import com.agfa.pacs.listtext.lta.filter.FilterHelper;
import com.agfa.pacs.listtext.lta.filter.FilterUtilities;
import com.agfa.pacs.listtext.lta.search.ISearchThread;
import com.agfa.pacs.listtext.lta.search.SearchHandler;
import com.agfa.pacs.listtext.lta.util.referencedobject.KeyObjectParser;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DataFinderUtilities {
    private static final ALogger logger = ALogger.getLogger(DataFinderUtilities.class);

    public static List<IStudyInfo> findStudies(String string, String string2, String string3, String string4, boolean bl) {
        List<IStudyInfo> list = null;
        String string5 = null;
        IDataInfoSource iDataInfoSource = null;
        if (logger.isDebugEnabled()) {
            string5 = "(UID: " + string3 + ", AccNr: " + string4 + ")";
            logger.debug("Lookup study " + string5 + " ...");
        }
        for (IDataFinder iDataFinder : DataFinderFactory.getInstance().getDataFinders()) {
            list = iDataFinder.findStudies(string, string2, string3, string4, bl);
            if (list == null || list.isEmpty()) continue;
            iDataInfoSource = list.get(0).getSource();
            break;
        }
        if (logger.isDebugEnabled()) {
            if (iDataInfoSource != null) {
                logger.debug("Study found: " + string5 + " on " + iDataInfoSource);
            } else {
                logger.debug("Study not found " + string5);
            }
        }
        return list;
    }

    public static List<IObjectInfo> findObjects(IDataInfoSource iDataInfoSource, Collection<String> collection) {
        return DataFinderUtilities.findObjects(Collections.singletonList(iDataInfoSource), collection);
    }

    public static List<IObjectInfo> findObjects(Collection<? extends IDataInfoSource> collection, Collection<String> collection2) {
        SearchHandler<IDataInfoSource> searchHandler = new SearchHandler<IDataInfoSource>();
        for (IDataInfoSource iDataInfoSource2 : collection) {
            searchHandler.addDataInfoSource(iDataInfoSource2);
        }
        if (collection2.isEmpty()) {
            return new ArrayList<IObjectInfo>(0);
        }
        Cancelable cancelable = searchHandler.search(FilterUtilities.getInstances(collection2), null, false);
        if (cancelable instanceof ISearchThread) {
            return DataInfoUtilities.getLevel((IDataInfo)((ISearchThread)cancelable).getResult(), IObjectInfo.class);
        }
        return null;
    }

    public static List<IObjectInfo> findKOObjects(IDataInfoSource iDataInfoSource, Map<String, ReferencedSOP> map) {
        return DataFinderUtilities.findKOObjects(iDataInfoSource, map, null);
    }

    public static List<IObjectInfo> findKOObjects(IDataInfoSource iDataInfoSource, Map<String, ReferencedSOP> map, String string) {
        SearchHandler<IDataInfoSource> searchHandler = new SearchHandler<IDataInfoSource>();
        searchHandler.addDataInfoSource(iDataInfoSource);
        String string2 = iDataInfoSource.getIdentifier().getType();
        if (string2.equals("DICOM") || string2.equals("DICOMPS")) {
            IRootInfo iRootInfo = DataInfoUtilities.createRoot();
            for (ReferencedSOP referencedSOP : map.values()) {
                Cancelable cancelable = searchHandler.search(KeyObjectParser.getFilter(referencedSOP), null, false);
                if (!(cancelable instanceof ISearchThread)) continue;
                DataInfoUtilities.mergeRoots((IRootInfo)iRootInfo, (IRootInfo)((ISearchThread)cancelable).getResult());
            }
            return DataInfoUtilities.getLevel((IDataInfo)iRootInfo, IObjectInfo.class);
        }
        Cancelable cancelable = searchHandler.search(FilterUtilities.getInstancesByKeys(map.keySet(), string), null, false);
        if (cancelable instanceof ISearchThread) {
            return DataInfoUtilities.getLevel((IDataInfo)((ISearchThread)cancelable).getResult(), IObjectInfo.class);
        }
        return null;
    }

    public static List<IObjectInfo> findObjectsIncremental(List<? extends IDataInfoSource> list, Collection<ReferencedSOP> collection, boolean bl, String string) {
        ReferencedSOP referencedSOP22;
        if (list == null || list.isEmpty()) {
            logger.warn("No source nodes specified. Incremental search will return 0 results!");
            return Collections.emptyList();
        }
        if (collection == null || collection.isEmpty()) {
            logger.warn("No instance-uids specified. Incremental search will return 0 results!");
            return Collections.emptyList();
        }
        HashMap<String, ReferencedSOP> hashMap = new HashMap<String, ReferencedSOP>(collection.size());
        for (ReferencedSOP referencedSOP22 : collection) {
            hashMap.put(referencedSOP22.getSOPInstanceUID(), referencedSOP22);
        }
        referencedSOP22 = new ArrayList();
        IRootInfo iRootInfo = null;
        if (bl) {
            iRootInfo = DataFinderUtilities.fastSessionRetrieval(hashMap, list, string, (List<IObjectInfo>)referencedSOP22);
        }
        for (IDataInfoSource iDataInfoSource : list) {
            if (hashMap.isEmpty()) break;
            logger.debug("Incremental search for " + hashMap.size() + " instances in source node " + iDataInfoSource);
            List<IObjectInfo> list2 = DataFinderUtilities.findKOObjects(iDataInfoSource, hashMap, string);
            if (list2 == null || list2.isEmpty()) continue;
            referencedSOP22.addAll(list2);
            List list3 = DataInfoUtilities.getRoots(list2);
            if (list3 != null) {
                for (IRootInfo iRootInfo2 : list3) {
                    iRootInfo = iRootInfo == null ? iRootInfo2 : DataInfoUtilities.mergeRoots((IRootInfo)iRootInfo, (IRootInfo)iRootInfo2);
                }
            }
            for (IObjectInfo iObjectInfo : list2) {
                hashMap.remove(iObjectInfo.getSOPInstanceUID());
            }
        }
        if (!hashMap.isEmpty()) {
            logger.warn("Unable to find all instances. Missing Objects: " + hashMap.size());
        }
        return referencedSOP22;
    }

    private static IRootInfo fastSessionRetrieval(Map<String, ReferencedSOP> map, List<? extends IDataInfoSource> list, String string, List<IObjectInfo> list2) {
        ReferencedSOP referencedSOP2;
        HashSet<SOPInstanceReference> hashSet = new HashSet<SOPInstanceReference>();
        for (ReferencedSOP referencedSOP2 : map.values()) {
            hashSet.add(referencedSOP2.getSeries().getStudyRef());
        }
        referencedSOP2 = null;
        for (IDataInfoSource iDataInfoSource : list) {
            for (SOPInstanceReference sOPInstanceReference : hashSet) {
                IDataInfo iDataInfo = FilterHelper.performSyncSearch(FilterUtilities.getStudyForUID(sOPInstanceReference.getStudyInstanceUID(), string), iDataInfoSource);
                if (iDataInfo == null) continue;
                IRootInfo iRootInfo = DataInfoUtilities.getRoot((IDataInfo)iDataInfo);
                if (referencedSOP2 == null) {
                    referencedSOP2 = iRootInfo;
                } else {
                    DataInfoUtilities.mergeRoots((IRootInfo)referencedSOP2, (IRootInfo)iRootInfo);
                }
                List list3 = DataInfoUtilities.getLevel((IDataInfo)iRootInfo, (Level)Level.Object);
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    String string2 = ((IObjectInfo)iterator.next()).getKey();
                    if (!map.containsKey(string2)) {
                        iterator.remove();
                        continue;
                    }
                    map.remove(string2);
                }
                list2.addAll(list3);
            }
            if (map.isEmpty()) break;
        }
        return referencedSOP2;
    }
}

