/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.store;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.NodeProperty;
import com.agfa.pacs.data.shared.dicom.IDicomNode;
import com.agfa.pacs.data.shared.dicom.SimpleDicomNode;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.List;

public class MWLNode
implements IDicomNode {
    public static final String NODE_CONFIG = "listtext.import.MWNodes";
    private SimpleDicomNode queryNode;
    private SimpleDicomNode mppsNode = null;
    private boolean sendMppsToArchive;

    public String getCalledAET() {
        return this.queryNode.getCalledAET();
    }

    public String getCallingAET() {
        return this.queryNode.getCallingAET();
    }

    public String getHost() {
        return this.queryNode.getHost();
    }

    public int getPort() {
        return this.queryNode.getPort();
    }

    public boolean isEnabled(NodeProperty nodeProperty) {
        return false;
    }

    public IDicomNode getMPPSNode(IDicomNode iDicomNode) {
        if (this.sendMppsToArchive) {
            return iDicomNode;
        }
        if (this.mppsNode != null) {
            return this.mppsNode;
        }
        return this.queryNode;
    }

    public static List<MWLNode> getConfiguredNodes() {
        return MWLNode.getConfiguredNodes(ConfigurationProviderFactory.getConfig());
    }

    public static List<MWLNode> getConfiguredNodes(IConfigurationProvider iConfigurationProvider) {
        IConfigurationList iConfigurationList = iConfigurationProvider.getList(NODE_CONFIG);
        ArrayList<MWLNode> arrayList = new ArrayList<MWLNode>();
        for (IConfigurationProvider iConfigurationProvider2 : iConfigurationList) {
            try {
                arrayList.add(MWLNode.loadFromConfig(iConfigurationProvider2));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ALogger.getLogger(MWLNode.class).warn("Incorrect MWL node configuration", (Throwable)illegalArgumentException);
            }
        }
        return arrayList;
    }

    private static MWLNode loadFromConfig(IConfigurationProvider iConfigurationProvider) {
        MWLNode mWLNode = new MWLNode();
        mWLNode.initFromConfig(iConfigurationProvider);
        return mWLNode;
    }

    public String toString() {
        return this.queryNode.toString();
    }

    void initFromConfig(IConfigurationProvider iConfigurationProvider) {
        String string = iConfigurationProvider.getString("calledAET");
        String string2 = iConfigurationProvider.getString("name");
        String string3 = iConfigurationProvider.getString("host");
        int n = (int)iConfigurationProvider.getLong("port");
        String string4 = null;
        if (iConfigurationProvider.exists("callingAET")) {
            string4 = iConfigurationProvider.getString("callingAET");
        }
        this.queryNode = new SimpleDicomNode(string3, n, string, string4, true, string2);
        if (iConfigurationProvider.exists("mppsToStore")) {
            this.sendMppsToArchive = iConfigurationProvider.getBoolean("mppsToStore");
        }
        if (iConfigurationProvider.exists("mppsHost") && iConfigurationProvider.exists("mppsPort") && iConfigurationProvider.exists("mppsCalledAET")) {
            string = iConfigurationProvider.getString("mppsCalledAET");
            string3 = iConfigurationProvider.getString("mppsHost");
            n = (int)iConfigurationProvider.getLong("mppsPort");
            this.mppsNode = new SimpleDicomNode(string3, n, string, string4);
        }
    }
}

