/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.lta.store;

import com.agfa.pacs.data.shared.JobState;
import com.agfa.pacs.data.shared.store.IStoreHandler;
import com.agfa.pacs.data.shared.store.IStoreListener;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractStoreHandler
implements IStoreHandler {
    private final Collection<IStoreListener> storeListeners = new CopyOnWriteArrayList<IStoreListener>();

    public void setStoreListener(IStoreListener iStoreListener) {
        if (iStoreListener != null) {
            this.addStoreListener(iStoreListener);
        }
    }

    public void addStoreListener(IStoreListener iStoreListener) {
        this.storeListeners.add(iStoreListener);
        iStoreListener.storeStateChanged(this.getProgressState());
    }

    public boolean removeStoreListener(IStoreListener iStoreListener) {
        return this.storeListeners.remove(iStoreListener);
    }

    protected boolean hasListeners() {
        return !this.storeListeners.isEmpty();
    }

    protected void informListeners() {
        this.informListeners(this.getProgressState());
    }

    protected void informListeners(JobState jobState) {
        for (IStoreListener iStoreListener : this.storeListeners) {
            iStoreListener.storeStateChanged(jobState);
        }
    }
}

